/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.serde2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types", "input.regex", "output.format.string", "input.regex.case.insensitive"})
public class RegexSerDe
extends AbstractSerDe {
    public static final String INPUT_REGEX = "input.regex";
    public static final String OUTPUT_FORMAT_STRING = "output.format.string";
    public static final String INPUT_REGEX_CASE_SENSITIVE = "input.regex.case.insensitive";
    int numColumns;
    String inputRegex;
    String outputFormatString;
    Pattern inputPattern;
    StructObjectInspector rowOI;
    ArrayList<String> row;
    long unmatchedRows = 0L;
    long nextUnmatchedRows = 1L;
    long partialMatchedRows = 0L;
    long nextPartialMatchedRows = 1L;
    Object[] outputFields;
    Text outputRowText;

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.numColumns = this.getColumnNames().size();
        this.inputRegex = this.properties.getProperty(INPUT_REGEX);
        this.outputFormatString = this.properties.getProperty(OUTPUT_FORMAT_STRING);
        boolean inputRegexIgnoreCase = "true".equalsIgnoreCase(this.properties.getProperty(INPUT_REGEX_CASE_SENSITIVE));
        this.inputPattern = this.inputRegex != null ? Pattern.compile(this.inputRegex, 32 + (inputRegexIgnoreCase ? 2 : 0)) : null;
        int i = 0;
        for (TypeInfo type : this.getColumnTypes()) {
            if (!type.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                throw new SerDeException(((Object)((Object)this)).getClass().getName() + " only accepts string columns, but column[" + i + "] named " + (String)this.getColumnNames().get(i) + " has type " + type);
            }
            ++i;
        }
        List<JavaStringObjectInspector> columnOIs = Collections.nCopies(this.numColumns, PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector((List)this.getColumnNames(), columnOIs);
        this.row = new ArrayList<Object>(Collections.nCopies(this.numColumns, null));
        this.outputFields = new Object[this.numColumns];
        this.outputRowText = new Text();
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    long getNextNumberToDisplay(long now) {
        return now * 10L;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (this.inputPattern == null) {
            throw new SerDeException("This table does not have serde property \"input.regex\"!");
        }
        Text rowText = (Text)blob;
        Matcher m = this.inputPattern.matcher(rowText.toString());
        if (!m.matches()) {
            ++this.unmatchedRows;
            if (this.unmatchedRows >= this.nextUnmatchedRows) {
                this.nextUnmatchedRows = this.getNextNumberToDisplay(this.nextUnmatchedRows);
                this.log.warn("{} unmatched rows are found: {}", (Object)this.unmatchedRows, (Object)rowText);
            }
            return null;
        }
        for (int c = 0; c < this.numColumns; ++c) {
            try {
                this.row.set(c, m.group(c + 1));
                continue;
            }
            catch (RuntimeException e) {
                ++this.partialMatchedRows;
                if (this.partialMatchedRows >= this.nextPartialMatchedRows) {
                    this.nextPartialMatchedRows = this.getNextNumberToDisplay(this.nextPartialMatchedRows);
                    this.log.warn("" + this.partialMatchedRows + " partially unmatched rows are found,  cannot find group " + c + ": " + rowText);
                }
                this.row.set(c, null);
            }
        }
        return this.row;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (this.outputFormatString == null) {
            throw new SerDeException("Cannot write data into table because \"output.format.string\" is not specified in serde properties of the table.");
        }
        StructObjectInspector outputRowOI = (StructObjectInspector)objInspector;
        List outputFieldRefs = outputRowOI.getAllStructFieldRefs();
        if (outputFieldRefs.size() != this.numColumns) {
            throw new SerDeException("Cannot serialize the object because there are " + outputFieldRefs.size() + " fields but the table has " + this.numColumns + " columns.");
        }
        for (int c = 0; c < this.numColumns; ++c) {
            Object field = outputRowOI.getStructFieldData(obj, (StructField)outputFieldRefs.get(c));
            ObjectInspector fieldOI = ((StructField)outputFieldRefs.get(c)).getFieldObjectInspector();
            StringObjectInspector fieldStringOI = (StringObjectInspector)fieldOI;
            this.outputFields[c] = fieldStringOI.getPrimitiveJavaObject(field);
        }
        String outputRowString = null;
        try {
            outputRowString = String.format(this.outputFormatString, this.outputFields);
        }
        catch (MissingFormatArgumentException e) {
            throw new SerDeException("The table contains " + this.numColumns + " columns, but the outputFormatString is asking for more.", (Throwable)e);
        }
        this.outputRowText.set(outputRowString);
        return this.outputRowText;
    }
}

