/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.intset;

import it.uniroma3.mat.extendedset.intset.AbstractIntSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ArraySet
extends AbstractIntSet {
    private int[] elements = null;
    private int size = 0;

    private void replaceWith(ArraySet other) {
        this.size = other.size;
        this.elements = other.elements;
    }

    @Override
    public double bitmapCompressionRatio() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return (double)this.size() / Math.ceil((double)this.elements[this.size - 1] / 32.0);
    }

    @Override
    public double collectionCompressionRatio() {
        return this.isEmpty() ? 0.0 : 1.0;
    }

    @Override
    public ArraySet empty() {
        return new ArraySet();
    }

    @Override
    public IntSet.IntIterator iterator() {
        return new IntSet.IntIterator(){
            int next = 0;

            @Override
            public void skipAllBefore(int e) {
                if (e <= ArraySet.this.elements[this.next]) {
                    return;
                }
                this.next = Arrays.binarySearch(ArraySet.this.elements, this.next + 1, ArraySet.this.size, e);
                if (this.next < 0) {
                    this.next = -(this.next + 1);
                }
            }

            @Override
            public boolean hasNext() {
                return this.next < ArraySet.this.size;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ArraySet.this.elements[this.next++];
            }

            @Override
            public void remove() {
                --this.next;
                ArraySet.this.size--;
                System.arraycopy(ArraySet.this.elements, this.next + 1, ArraySet.this.elements, this.next, ArraySet.this.size - this.next);
                ArraySet.this.compact();
            }

            @Override
            public IntSet.IntIterator clone() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public IntSet.IntIterator descendingIterator() {
        return new IntSet.IntIterator(){
            int next;
            {
                this.next = ArraySet.this.size - 1;
            }

            @Override
            public void skipAllBefore(int e) {
                if (e >= ArraySet.this.elements[this.next]) {
                    return;
                }
                this.next = Arrays.binarySearch(ArraySet.this.elements, 0, this.next, e);
                if (this.next < 0) {
                    this.next = -(this.next + 1) - 1;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next >= 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ArraySet.this.elements[this.next--];
            }

            @Override
            public void remove() {
                ++this.next;
                ArraySet.this.size--;
                System.arraycopy(ArraySet.this.elements, this.next + 1, ArraySet.this.elements, this.next, ArraySet.this.size - this.next);
                ArraySet.this.compact();
            }

            @Override
            public IntSet.IntIterator clone() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ArraySet clone() {
        ArraySet c = this.empty();
        if (!this.isEmpty()) {
            c.elements = Arrays.copyOf(this.elements, this.elements.length);
            c.size = this.size;
        }
        return c;
    }

    @Override
    public String debugInfo() {
        return this.toString();
    }

    private void ensureCapacity() {
        int capacity;
        int n = capacity = this.elements == null ? 0 : this.elements.length;
        if (capacity >= this.size) {
            return;
        }
        capacity = Math.max(capacity << 1, this.size);
        if (this.elements == null) {
            this.elements = new int[capacity];
            return;
        }
        this.elements = Arrays.copyOf(this.elements, capacity);
    }

    private void compact() {
        if (this.size == 0) {
            this.elements = null;
            return;
        }
        if (this.elements != null && this.size << 1 < this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public boolean add(int element) {
        if (this.isEmpty() || this.elements[this.size - 1] < element) {
            ++this.size;
            this.ensureCapacity();
            this.elements[this.size - 1] = element;
            return true;
        }
        int pos = Arrays.binarySearch(this.elements, 0, this.size, element);
        if (pos >= 0) {
            return false;
        }
        ++this.size;
        this.ensureCapacity();
        pos = -(pos + 1);
        System.arraycopy(this.elements, pos, this.elements, pos + 1, this.size - pos - 1);
        this.elements[pos] = element;
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (element < 0) {
            return false;
        }
        int pos = Arrays.binarySearch(this.elements, 0, this.size, element);
        if (pos < 0) {
            return false;
        }
        --this.size;
        System.arraycopy(this.elements, pos + 1, this.elements, pos, this.size - pos);
        this.compact();
        return true;
    }

    @Override
    public void flip(int element) {
        if (this.isEmpty()) {
            ++this.size;
            this.ensureCapacity();
            this.elements[this.size - 1] = element;
            return;
        }
        int pos = Arrays.binarySearch(this.elements, 0, this.size, element);
        if (pos < 0) {
            ++this.size;
            this.ensureCapacity();
            pos = -(pos + 1);
            System.arraycopy(this.elements, pos, this.elements, pos + 1, this.size - pos - 1);
            this.elements[pos] = element;
            return;
        }
        --this.size;
        System.arraycopy(this.elements, pos + 1, this.elements, pos, this.size - pos);
        this.compact();
    }

    @Override
    public boolean contains(int element) {
        if (this.isEmpty()) {
            return false;
        }
        return Arrays.binarySearch(this.elements, 0, this.size, element) >= 0;
    }

    @Override
    public boolean containsAll(IntSet c) {
        if (c == null || c.isEmpty() || c == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        ArraySet o = this.convert(c);
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] < otherElements[otherIndex]) {
                if (thisIndex == this.size - 1) {
                    return false;
                }
                ++thisIndex;
            }
            if (thisElements[thisIndex] <= otherElements[otherIndex]) continue;
            return false;
        }
        return otherIndex == otherSize - 1;
    }

    @Override
    public boolean containsAny(IntSet other) {
        if (other == null || other.isEmpty() || other == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        ArraySet o = this.convert(other);
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        if (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    if (otherIndex == otherSize - 1) {
                        return false;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) break;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    if (thisIndex == this.size - 1) {
                        return false;
                    }
                    ++thisIndex;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(IntSet other, int minElements) {
        if (minElements < 1) {
            throw new IllegalArgumentException();
        }
        if (this.size >= 0 && this.size < minElements || other == null || other.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (this == other) {
            return this.size() >= minElements;
        }
        ArraySet o = this.convert(other);
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        int res = 0;
        while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    if (otherIndex == otherSize - 1) {
                        return false;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) break;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    if (thisIndex == this.size - 1) {
                        return false;
                    }
                    ++thisIndex;
                }
            }
            if (++res < minElements) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(IntSet c) {
        ArraySet res = this.union(c);
        boolean r = !this.equals(res);
        this.replaceWith(res);
        return r;
    }

    @Override
    public boolean retainAll(IntSet c) {
        ArraySet res = this.intersection(c);
        boolean r = !this.equals(res);
        this.replaceWith(res);
        return r;
    }

    @Override
    public boolean removeAll(IntSet c) {
        ArraySet res = this.difference(c);
        boolean r = !this.equals(res);
        this.replaceWith(res);
        return r;
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int[] thisElements = this.elements;
        int h = 1;
        for (int i = 0; i < this.size; ++i) {
            h = (h << 5) - h + thisElements[i];
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArraySet)) {
            return super.equals(obj);
        }
        ArraySet other = (ArraySet)obj;
        if (this.size != other.size) {
            return false;
        }
        int[] thisElements = this.elements;
        int[] otherElements = other.elements;
        for (int i = 0; i < this.size; ++i) {
            if (thisElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.elements = null;
        this.size = 0;
    }

    @Override
    public int first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[this.size - 1];
    }

    @Override
    public int intersectionSize(IntSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return 0;
        }
        if (this == other) {
            return this.size();
        }
        ArraySet o = this.convert(other);
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        int res = 0;
        while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    if (otherIndex == otherSize - 1) {
                        return res;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) break;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    if (thisIndex == this.size - 1) {
                        return res;
                    }
                    ++thisIndex;
                }
            }
            ++res;
        }
        return res;
    }

    @Override
    public ArraySet intersection(IntSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return this.empty();
        }
        if (this == other) {
            return this.clone();
        }
        ArraySet o = this.convert(other);
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        int resSize = 0;
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int[] resElements = new int[Math.min(this.size, otherSize)];
        while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    if (otherIndex == otherSize - 1) {
                        ArraySet res = this.empty();
                        res.elements = resElements;
                        res.size = resSize;
                        res.compact();
                        return res;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) break;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    if (thisIndex == this.size - 1) {
                        ArraySet res = this.empty();
                        res.elements = resElements;
                        res.size = resSize;
                        res.compact();
                        return res;
                    }
                    ++thisIndex;
                }
            }
            resElements[resSize++] = thisElements[thisIndex];
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        res.compact();
        return res;
    }

    @Override
    public ArraySet union(IntSet other) {
        if (this == other || other == null || other.isEmpty()) {
            return this.clone();
        }
        if (this.isEmpty()) {
            ArraySet cloned = this.convert(other);
            if (cloned == other) {
                cloned = cloned.clone();
            }
            return cloned;
        }
        ArraySet o = this.convert(other);
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        int resSize = 0;
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int[] resElements = new int[this.size + otherSize];
        block0: while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    resElements[resSize++] = otherElements[otherIndex];
                    if (otherIndex == otherSize - 1) {
                        resElements[resSize++] = thisElements[thisIndex];
                        break block0;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) break;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    resElements[resSize++] = thisElements[thisIndex];
                    if (thisIndex == this.size - 1) {
                        resElements[resSize++] = otherElements[otherIndex];
                        break block0;
                    }
                    ++thisIndex;
                }
            }
            resElements[resSize++] = thisElements[thisIndex];
        }
        while (thisIndex < this.size - 1) {
            resElements[resSize++] = thisElements[++thisIndex];
        }
        while (otherIndex < otherSize - 1) {
            resElements[resSize++] = otherElements[++otherIndex];
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        res.compact();
        return res;
    }

    @Override
    public ArraySet difference(IntSet other) {
        if (this.isEmpty() || this == other) {
            return this.empty();
        }
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        ArraySet o = this.convert(other);
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        int resSize = 0;
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int[] resElements = new int[this.size];
        block0: while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    if (otherIndex == otherSize - 1) {
                        resElements[resSize++] = thisElements[thisIndex];
                        break block0;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) continue block0;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    resElements[resSize++] = thisElements[thisIndex];
                    if (thisIndex == this.size - 1) break block0;
                    ++thisIndex;
                }
            }
        }
        while (thisIndex < this.size - 1) {
            resElements[resSize++] = thisElements[++thisIndex];
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        res.compact();
        return res;
    }

    @Override
    public ArraySet symmetricDifference(IntSet other) {
        if (this == other || other == null || other.isEmpty()) {
            return this.clone();
        }
        if (this.isEmpty()) {
            return this.convert(other).clone();
        }
        ArraySet o = this.convert(other);
        int otherSize = o.size;
        int thisIndex = -1;
        int otherIndex = -1;
        int resSize = 0;
        int[] thisElements = this.elements;
        int[] otherElements = o.elements;
        int[] resElements = new int[this.size + otherSize];
        block0: while (thisIndex < this.size - 1 && otherIndex < otherSize - 1) {
            ++thisIndex;
            ++otherIndex;
            while (thisElements[thisIndex] != otherElements[otherIndex]) {
                while (thisElements[thisIndex] > otherElements[otherIndex]) {
                    resElements[resSize++] = otherElements[otherIndex];
                    if (otherIndex == otherSize - 1) {
                        resElements[resSize++] = thisElements[thisIndex];
                        break block0;
                    }
                    ++otherIndex;
                }
                if (thisElements[thisIndex] == otherElements[otherIndex]) continue block0;
                while (thisElements[thisIndex] < otherElements[otherIndex]) {
                    resElements[resSize++] = thisElements[thisIndex];
                    if (thisIndex == this.size - 1) {
                        resElements[resSize++] = otherElements[otherIndex];
                        break block0;
                    }
                    ++thisIndex;
                }
            }
        }
        while (thisIndex < this.size - 1) {
            resElements[resSize++] = thisElements[++thisIndex];
        }
        while (otherIndex < otherSize - 1) {
            resElements[resSize++] = otherElements[++otherIndex];
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        res.compact();
        return res;
    }

    @Override
    public void complement() {
        if (this.isEmpty()) {
            return;
        }
        IntSet.IntIterator thisItr = this.clone().iterator();
        int[] thisElements = this.elements = new int[this.complementSize()];
        this.size = 0;
        int u = -1;
        while (thisItr.hasNext()) {
            int c = thisItr.next();
            while (++u < c) {
                thisElements[this.size++] = u;
            }
        }
    }

    @Override
    public void fill(int from, int to) {
        int gap;
        int posTo;
        boolean toMissing;
        boolean fromMissing;
        if (from > to) {
            throw new IndexOutOfBoundsException("from: " + from + " > to: " + to);
        }
        if (from == to) {
            this.add(from);
            return;
        }
        int[] thisElements = this.elements;
        if (this.isEmpty()) {
            this.size = to - from + 1;
            this.ensureCapacity();
            thisElements = this.elements;
            for (int i = 0; i < this.size; ++i) {
                thisElements[i] = from++;
            }
            return;
        }
        int posFrom = Arrays.binarySearch(thisElements, 0, this.size, from);
        boolean bl = fromMissing = posFrom < 0;
        if (fromMissing) {
            posFrom = -posFrom - 1;
        }
        boolean bl2 = toMissing = (posTo = Arrays.binarySearch(thisElements, posFrom, this.size, to)) < 0;
        if (toMissing) {
            posTo = -posTo - 1;
        }
        int delta = 0;
        if (toMissing || fromMissing && posFrom == posTo + 1) {
            delta = 1;
        }
        if ((delta += (gap = to - from) - (posTo - posFrom)) > 0) {
            this.size += delta;
            this.ensureCapacity();
            thisElements = this.elements;
            System.arraycopy(thisElements, posTo, thisElements, posTo + delta, this.size - delta - posTo);
            posTo = posFrom + gap;
            for (int i = posFrom; i <= posTo; ++i) {
                thisElements[i] = from++;
            }
        }
    }

    @Override
    public void clear(int from, int to) {
        if (this.isEmpty()) {
            return;
        }
        if (from > to) {
            throw new IndexOutOfBoundsException("from: " + from + " > to: " + to);
        }
        if (from == to) {
            this.remove(from);
            return;
        }
        int posFrom = Arrays.binarySearch(this.elements, 0, this.size, from);
        if (posFrom < 0) {
            posFrom = -posFrom - 1;
        }
        if (posFrom >= this.size) {
            return;
        }
        int posTo = Arrays.binarySearch(this.elements, posFrom, this.size, to);
        posTo = posTo >= 0 ? ++posTo : -posTo - 1;
        if (posFrom == posTo) {
            return;
        }
        System.arraycopy(this.elements, posTo, this.elements, posFrom, this.size - posTo);
        this.size -= posTo - posFrom;
    }

    private ArraySet convert(IntSet c) {
        if (c instanceof ArraySet) {
            return (ArraySet)c;
        }
        int[] resElements = new int[c.size()];
        int resSize = 0;
        IntSet.IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            resElements[resSize++] = itr.next();
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        return res;
    }

    @Override
    public ArraySet convert(int ... a) {
        int[] resElements = null;
        int resSize = 0;
        int last = -1;
        if (a != null) {
            resElements = new int[a.length];
            a = Arrays.copyOf(a, a.length);
            Arrays.sort(a);
            if (a[0] < 0) {
                throw new ArrayIndexOutOfBoundsException(Integer.toString(a[0]));
            }
            for (int i : a) {
                if (last == i) continue;
                resElements[resSize++] = last = i;
            }
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        return res;
    }

    @Override
    public ArraySet convert(Collection<Integer> c) {
        int[] resElements = null;
        int resSize = 0;
        int last = -1;
        if (c != null) {
            Collection<Integer> sorted;
            resElements = new int[c.size()];
            if (c instanceof SortedSet && ((SortedSet)c).comparator() == null) {
                sorted = c;
            } else {
                sorted = new ArrayList<Integer>(c);
                Collections.sort((List)sorted);
                int first = (Integer)((ArrayList)sorted).get(0);
                if (first < 0) {
                    throw new ArrayIndexOutOfBoundsException(Integer.toString(first));
                }
            }
            for (int i : sorted) {
                if (last == i) continue;
                resElements[resSize++] = last = i;
            }
        }
        ArraySet res = this.empty();
        res.elements = resElements;
        res.size = resSize;
        return res;
    }

    @Override
    public ArraySet complemented() {
        ArraySet res = this.clone();
        res.complement();
        return res;
    }

    @Override
    public int get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return this.elements[i];
    }

    @Override
    public int indexOf(int e) {
        if (e < 0) {
            throw new IllegalArgumentException("positive integer expected: " + Integer.toString(e));
        }
        int pos = Arrays.binarySearch(this.elements, 0, this.size, e);
        if (pos < 0) {
            return -1;
        }
        return pos;
    }
}

