/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.utilities;

import java.util.Random;

public class BitCount {
    public static int count(int word) {
        word -= word >>> 1 & 0x55555555;
        word = (word & 0x33333333) + (word >>> 2 & 0x33333333);
        word = word + (word >>> 4) & 0xF0F0F0F;
        return word * 0x1010101 >>> 24;
    }

    public static int count(int[] buffer) {
        return BitCount.count(buffer, buffer.length);
    }

    public static int count(int[] buffer, int n) {
        int i;
        int n1 = n - n % 24;
        int n2 = n - n % 3;
        int cnt = 0;
        for (i = 0; i < n1; i += 24) {
            cnt += BitCount.merging3(buffer, i);
        }
        while (i < n2) {
            cnt += BitCount.merging2(buffer, i);
            i += 3;
        }
        return cnt += BitCount.popcount_fbsd2(buffer, i, n);
    }

    private static int merging3(int[] buffer, int x) {
        int cnt = 0;
        for (int i = x; i < x + 24; i += 3) {
            int cnt1 = buffer[i];
            int cnt2 = buffer[i + 1];
            int w = buffer[i + 2];
            cnt1 = cnt1 - (cnt1 >>> 1 & 0x55555555) + (w & 0x55555555);
            cnt2 = cnt2 - (cnt2 >>> 1 & 0x55555555) + (w >>> 1 & 0x55555555);
            cnt1 = (cnt1 & 0x33333333) + (cnt1 >>> 2 & 0x33333333);
            cnt += ((cnt1 += (cnt2 & 0x33333333) + (cnt2 >>> 2 & 0x33333333)) & 0xF0F0F0F) + (cnt1 >>> 4 & 0xF0F0F0F);
        }
        cnt = (cnt & 0xFF00FF) + (cnt >>> 8 & 0xFF00FF);
        cnt += cnt >>> 16;
        return cnt & 0xFFFF;
    }

    private static int merging2(int[] buffer, int x) {
        int cnt1 = buffer[x];
        int cnt2 = buffer[x + 1];
        int w = buffer[x + 2];
        cnt1 = cnt1 - (cnt1 >>> 1 & 0x55555555) + (w & 0x55555555);
        cnt2 = cnt2 - (cnt2 >>> 1 & 0x55555555) + (w >>> 1 & 0x55555555);
        cnt1 = (cnt1 & 0x33333333) + (cnt1 >>> 2 & 0x33333333);
        cnt2 = (cnt2 & 0x33333333) + (cnt2 >>> 2 & 0x33333333);
        cnt1 += cnt2;
        cnt1 = (cnt1 & 0xF0F0F0F) + (cnt1 >>> 4 & 0xF0F0F0F);
        cnt1 += cnt1 >>> 8;
        cnt1 += cnt1 >>> 16;
        return cnt1 & 0xFF;
    }

    private static int popcount_fbsd2(int[] data, int x, int n) {
        int cnt = 0;
        while (x < n) {
            cnt += BitCount.count(data[x]);
            ++x;
        }
        return cnt;
    }

    public static int count_2(int[] buffer) {
        return BitCount.count_2(buffer, buffer.length);
    }

    public static int count_2(int[] buffer, int n) {
        int i;
        int n1 = n - n % 48;
        int n2 = n - n % 6;
        int cnt = 0;
        for (i = 0; i < n1; i += 48) {
            cnt += BitCount.merging3_2(buffer, i);
        }
        while (i < n2) {
            cnt += BitCount.merging2_2(buffer, i);
            i += 6;
        }
        return cnt += BitCount.popcount_fbsd2_2(buffer, i, n);
    }

    private static int merging3_2(int[] buffer, int x) {
        int cnt = 0;
        for (int i = x; i < x + 48; i += 6) {
            int cnt1 = buffer[i + 1];
            int cnt2 = buffer[i + 3];
            int w = buffer[i + 5];
            cnt1 = cnt1 - (cnt1 >>> 1 & 0x55555555) + (w & 0x55555555);
            cnt2 = cnt2 - (cnt2 >>> 1 & 0x55555555) + (w >>> 1 & 0x55555555);
            cnt1 = (cnt1 & 0x33333333) + (cnt1 >>> 2 & 0x33333333);
            cnt += ((cnt1 += (cnt2 & 0x33333333) + (cnt2 >>> 2 & 0x33333333)) & 0xF0F0F0F) + (cnt1 >>> 4 & 0xF0F0F0F);
        }
        cnt = (cnt & 0xFF00FF) + (cnt >>> 8 & 0xFF00FF);
        cnt += cnt >>> 16;
        return cnt & 0xFFFF;
    }

    private static int merging2_2(int[] buffer, int x) {
        int cnt1 = buffer[x + 1];
        int cnt2 = buffer[x + 3];
        int w = buffer[x + 5];
        cnt1 = cnt1 - (cnt1 >>> 1 & 0x55555555) + (w & 0x55555555);
        cnt2 = cnt2 - (cnt2 >>> 1 & 0x55555555) + (w >>> 1 & 0x55555555);
        cnt1 = (cnt1 & 0x33333333) + (cnt1 >>> 2 & 0x33333333);
        cnt2 = (cnt2 & 0x33333333) + (cnt2 >>> 2 & 0x33333333);
        cnt1 += cnt2;
        cnt1 = (cnt1 & 0xF0F0F0F) + (cnt1 >>> 4 & 0xF0F0F0F);
        cnt1 += cnt1 >>> 8;
        cnt1 += cnt1 >>> 16;
        return cnt1 & 0xFF;
    }

    private static int popcount_fbsd2_2(int[] data, int x, int n) {
        int cnt = 0;
        ++x;
        while (x < n) {
            cnt += BitCount.count(data[x]);
            x += 2;
        }
        return cnt;
    }

    public static void main(String[] args) {
        int j;
        int size;
        int j2;
        int i;
        int size2;
        int j3;
        int size1;
        int j4;
        int[] x;
        int i2;
        int trials = 10000;
        int maxLength = 10000;
        Random rnd = new Random();
        int seed = rnd.nextInt();
        System.out.print("Test correctness... ");
        rnd = new Random(seed);
        for (i2 = 0; i2 < 10000; ++i2) {
            x = new int[rnd.nextInt(10000)];
            for (j4 = 0; j4 < x.length; ++j4) {
                x[j4] = rnd.nextInt(Integer.MAX_VALUE);
            }
            size1 = 0;
            for (j3 = 0; j3 < x.length; ++j3) {
                size1 += BitCount.count(x[j3]);
            }
            size2 = BitCount.count(x);
            if (size1 == size2) continue;
            System.out.println("i = " + i2);
            System.out.println("ERRORE!");
            System.out.println(size1 + ", " + size2);
            for (int j5 = 0; j5 < x.length; ++j5) {
                System.out.format("x[%d] = %d --> %d\n", j5, x[j5], BitCount.count(x[j5]));
            }
            return;
        }
        System.out.println("done!");
        System.out.print("Test correctness II... ");
        rnd = new Random(seed);
        for (i2 = 0; i2 < 10000; ++i2) {
            x = new int[rnd.nextInt(20000)];
            for (j4 = 1; j4 < x.length; j4 += 2) {
                x[j4] = rnd.nextInt(Integer.MAX_VALUE);
            }
            size1 = 0;
            for (j3 = 1; j3 < x.length; j3 += 2) {
                size1 += BitCount.count(x[j3]);
            }
            size2 = BitCount.count_2(x);
            if (size1 == size2) continue;
            System.out.println("i = " + i2);
            System.out.println("ERRORE!");
            System.out.println(size1 + ", " + size2);
            for (int j6 = 1; j6 < x.length; j6 += 2) {
                System.out.format("x[%d] = %d --> %d\n", j6, x[j6], BitCount.count(x[j6]));
            }
            return;
        }
        System.out.println("done!");
        System.out.print("Test time count(): ");
        rnd = new Random(seed);
        long t = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int[] x2 = new int[rnd.nextInt(10000)];
            for (j2 = 0; j2 < x2.length; ++j2) {
                x2[j2] = rnd.nextInt(Integer.MAX_VALUE);
            }
            size = 0;
            for (j = 0; j < x2.length; ++j) {
                size += BitCount.count(x2[j]);
            }
        }
        System.out.println(System.currentTimeMillis() - t);
        System.out.print("Test time BitCount.count():   ");
        rnd = new Random(seed);
        t = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int[] x3 = new int[rnd.nextInt(10000)];
            for (j2 = 0; j2 < x3.length; ++j2) {
                x3[j2] = rnd.nextInt(Integer.MAX_VALUE);
            }
            BitCount.count(x3);
        }
        System.out.println(System.currentTimeMillis() - t);
        System.out.print("Test II time count(): ");
        rnd = new Random(seed);
        t = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int[] x4 = new int[rnd.nextInt(20000)];
            for (j2 = 1; j2 < x4.length; j2 += 2) {
                x4[j2] = rnd.nextInt(Integer.MAX_VALUE);
            }
            size = 0;
            for (j = 1; j < x4.length; j += 2) {
                size += BitCount.count(x4[j]);
            }
        }
        System.out.println(System.currentTimeMillis() - t);
        System.out.print("Test II time BitCount.count():   ");
        rnd = new Random(seed);
        t = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int[] x5 = new int[rnd.nextInt(20000)];
            for (j2 = 1; j2 < x5.length; j2 += 2) {
                x5[j2] = rnd.nextInt(Integer.MAX_VALUE);
            }
            BitCount.count_2(x5);
        }
        System.out.println(System.currentTimeMillis() - t);
    }
}

