/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers;

import it.uniroma3.mat.extendedset.AbstractExtendedSet;
import it.uniroma3.mat.extendedset.ExtendedSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexedSet<T>
extends AbstractExtendedSet<T>
implements Serializable {
    private static final long serialVersionUID = -2386771695765773453L;
    private final IntSet indices;
    private final Map<T, Integer> itemToIndex;
    private final T[] indexToItem;

    public IndexedSet(IntSet indices, Collection<T> universe) {
        this.indexToItem = universe instanceof Set ? universe.toArray() : new LinkedHashSet<T>(universe).toArray();
        this.itemToIndex = new HashMap<T, Integer>(Math.max((int)((float)this.indexToItem.length / 0.75f) + 1, 16));
        for (int i = 0; i < this.indexToItem.length; ++i) {
            this.itemToIndex.put(this.indexToItem[i], i);
        }
        this.indices = indices;
    }

    private IndexedSet(Map<T, Integer> itemToIndex, T[] indexToItem, IntSet indices) {
        this.itemToIndex = itemToIndex;
        this.indexToItem = indexToItem;
        this.indices = indices;
    }

    private IndexedSet<T> createFromIndices(IntSet indx) {
        return new IndexedSet<T>(this.itemToIndex, this.indexToItem, indx);
    }

    private boolean hasSameIndices(Collection<?> c) {
        return c instanceof IndexedSet && this.indexToItem == ((IndexedSet)c).indexToItem;
    }

    @Override
    public IndexedSet<T> clone() {
        return this.createFromIndices(this.indices.clone());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Collection)) {
            return false;
        }
        ExtendedSet other = this.convert((Collection)obj);
        return this.indexToItem == ((IndexedSet)other).indexToItem && this.itemToIndex == ((IndexedSet)other).itemToIndex && this.indices.equals(((IndexedSet)other).indices);
    }

    @Override
    public int hashCode() {
        return this.indices.hashCode();
    }

    @Override
    public int compareTo(ExtendedSet<T> o) {
        return this.indices.compareTo(((IndexedSet)this.convert(o)).indices);
    }

    @Override
    public Comparator<? super T> comparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Integer)IndexedSet.this.itemToIndex.get(o1)).compareTo((Integer)IndexedSet.this.itemToIndex.get(o2));
            }
        };
    }

    @Override
    public T first() {
        return this.indexToItem[this.indices.first()];
    }

    @Override
    public T last() {
        return this.indexToItem[this.indices.last()];
    }

    @Override
    public boolean add(T e) {
        Integer index = this.itemToIndex.get(e);
        if (index == null) {
            throw new IllegalArgumentException("element not in the current universe");
        }
        return this.indices.add(index);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return c != null && !c.isEmpty() && this.indices.addAll(((IndexedSet)this.convert(c)).indices);
    }

    @Override
    public void clear() {
        this.indices.clear();
    }

    @Override
    public void flip(T e) {
        this.indices.flip(this.itemToIndex.get(e));
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Integer index = this.itemToIndex.get(o);
        return index != null && this.indices.contains(index);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c == null || this.indices.containsAll(((IndexedSet)this.convert(c)).indices);
    }

    @Override
    public boolean containsAny(Collection<? extends T> other) {
        return other == null || this.indices.containsAny(((IndexedSet)this.convert(other)).indices);
    }

    @Override
    public boolean containsAtLeast(Collection<? extends T> other, int minElements) {
        return other != null && !other.isEmpty() && this.indices.containsAtLeast(((IndexedSet)this.convert(other)).indices, minElements);
    }

    @Override
    public boolean isEmpty() {
        return this.indices.isEmpty();
    }

    @Override
    public ExtendedSet.ExtendedIterator<T> iterator() {
        return new ExtendedSet.ExtendedIterator<T>(){
            final IntSet.IntIterator itr;
            {
                this.itr = IndexedSet.this.indices.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public T next() {
                return IndexedSet.this.indexToItem[this.itr.next()];
            }

            @Override
            public void skipAllBefore(T element) {
                this.itr.skipAllBefore((Integer)IndexedSet.this.itemToIndex.get(element));
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        };
    }

    @Override
    public ExtendedSet.ExtendedIterator<T> descendingIterator() {
        return new ExtendedSet.ExtendedIterator<T>(){
            final IntSet.IntIterator itr;
            {
                this.itr = IndexedSet.this.indices.descendingIterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public T next() {
                return IndexedSet.this.indexToItem[this.itr.next()];
            }

            @Override
            public void skipAllBefore(T element) {
                this.itr.skipAllBefore((Integer)IndexedSet.this.itemToIndex.get(element));
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Integer index = this.itemToIndex.get(o);
        return index != null && this.indices.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return c != null && !c.isEmpty() && this.indices.removeAll(((IndexedSet)this.convert(c)).indices);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        if (c == null || c.isEmpty()) {
            this.indices.clear();
            return true;
        }
        return this.indices.retainAll(((IndexedSet)this.convert(c)).indices);
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public IndexedSet<T> intersection(Collection<? extends T> other) {
        if (other == null) {
            return this.empty();
        }
        return this.createFromIndices(this.indices.intersection(((IndexedSet)this.convert(other)).indices));
    }

    @Override
    public IndexedSet<T> union(Collection<? extends T> other) {
        if (other == null) {
            return this.clone();
        }
        return this.createFromIndices(this.indices.union(((IndexedSet)this.convert(other)).indices));
    }

    @Override
    public IndexedSet<T> difference(Collection<? extends T> other) {
        if (other == null) {
            return this.clone();
        }
        return this.createFromIndices(this.indices.difference(((IndexedSet)this.convert(other)).indices));
    }

    @Override
    public IndexedSet<T> symmetricDifference(Collection<? extends T> other) {
        if (other == null) {
            return this.clone();
        }
        return this.createFromIndices(this.indices.symmetricDifference(((IndexedSet)this.convert(other)).indices));
    }

    @Override
    public IndexedSet<T> complemented() {
        return this.createFromIndices(this.indices.complemented());
    }

    @Override
    public void complement() {
        this.indices.complement();
    }

    @Override
    public int intersectionSize(Collection<? extends T> other) {
        if (other == null) {
            return 0;
        }
        return this.indices.intersectionSize(((IndexedSet)this.convert(other)).indices);
    }

    @Override
    public int unionSize(Collection<? extends T> other) {
        if (other == null) {
            return this.size();
        }
        return this.indices.unionSize(((IndexedSet)this.convert(other)).indices);
    }

    @Override
    public int symmetricDifferenceSize(Collection<? extends T> other) {
        if (other == null) {
            return this.size();
        }
        return this.indices.symmetricDifferenceSize(((IndexedSet)this.convert(other)).indices);
    }

    @Override
    public int differenceSize(Collection<? extends T> other) {
        if (other == null) {
            return this.size();
        }
        return this.indices.differenceSize(((IndexedSet)this.convert(other)).indices);
    }

    @Override
    public int complementSize() {
        return this.indices.complementSize();
    }

    public IndexedSet<T> universe() {
        IntSet allItems = this.indices.empty();
        allItems.fill(0, this.indexToItem.length - 1);
        return this.createFromIndices(allItems);
    }

    public Integer absoluteIndexOf(T item) {
        return this.itemToIndex.get(item);
    }

    public T absoluteGet(int i) {
        return this.indexToItem[i];
    }

    public IntSet indices() {
        return this.indices;
    }

    @Override
    public IndexedSet<T> empty() {
        return this.createFromIndices(this.indices.empty());
    }

    @Override
    public double bitmapCompressionRatio() {
        return this.indices.bitmapCompressionRatio();
    }

    @Override
    public double collectionCompressionRatio() {
        return this.indices.collectionCompressionRatio();
    }

    @Override
    public IndexedSet<T> convert(Collection<?> c) {
        if (c == null) {
            return this.empty();
        }
        if (this.hasSameIndices(c)) {
            return (IndexedSet)c;
        }
        ExtendedSet res = this.empty();
        for (Object t : c) {
            ((IndexedSet)res).add((T)t);
        }
        return res;
    }

    @Override
    public IndexedSet<T> convert(Object ... e) {
        return (IndexedSet)super.convert(e);
    }

    @Override
    public List<? extends IndexedSet<T>> powerSet() {
        return this.powerSet(1, Integer.MAX_VALUE);
    }

    @Override
    public List<? extends IndexedSet<T>> powerSet(int min, int max) {
        List<? extends IntSet> ps = this.indices.powerSet(min, max);
        ArrayList<IndexedSet<T>> res = new ArrayList<IndexedSet<T>>(ps.size());
        for (IntSet intSet : ps) {
            res.add(this.createFromIndices(intSet));
        }
        return res;
    }

    @Override
    public String debugInfo() {
        return String.format("items = %s\nitemToIndex = %s\nindexToItem = %s\n", this.indices.debugInfo(), this.itemToIndex.toString(), Arrays.toString(this.indexToItem));
    }

    @Override
    public double jaccardSimilarity(ExtendedSet<T> other) {
        return this.indices.jaccardSimilarity(((IndexedSet)this.convert(other)).indices);
    }

    @Override
    public T get(int i) {
        return this.indexToItem[this.indices.get(i)];
    }

    @Override
    public int indexOf(T e) {
        return this.indices.indexOf(this.itemToIndex.get(e));
    }

    @Override
    public void clear(T from, T to) {
        this.indices.clear(this.itemToIndex.get(from), this.itemToIndex.get(to));
    }

    @Override
    public void fill(T from, T to) {
        this.indices.fill(this.itemToIndex.get(from), this.itemToIndex.get(to));
    }
}

