/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.guava;

import java.io.Serializable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.Deserializers;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.CollectionType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.MapType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.ReferenceType;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.HashCodeDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.HashMultisetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.HostAndPortDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableBiMapDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableListDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableMultisetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableSortedMapDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableSortedMultisetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.InternetDomainNameDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.LinkedHashMultisetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.RangeDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.RangeSetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.TreeMultisetDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.multimap.list.ArrayListMultimapDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.multimap.list.LinkedListMultimapDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.multimap.set.HashMultimapDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser.multimap.set.LinkedHashMultimapDeserializer;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.ArrayListMultimap;
import org.apache.hive.druid.com.google.common.collect.BiMap;
import org.apache.hive.druid.com.google.common.collect.BoundType;
import org.apache.hive.druid.com.google.common.collect.EnumBiMap;
import org.apache.hive.druid.com.google.common.collect.EnumHashBiMap;
import org.apache.hive.druid.com.google.common.collect.EnumMultiset;
import org.apache.hive.druid.com.google.common.collect.ForwardingListMultimap;
import org.apache.hive.druid.com.google.common.collect.ForwardingSetMultimap;
import org.apache.hive.druid.com.google.common.collect.ForwardingSortedSetMultimap;
import org.apache.hive.druid.com.google.common.collect.HashBiMap;
import org.apache.hive.druid.com.google.common.collect.HashMultimap;
import org.apache.hive.druid.com.google.common.collect.HashMultiset;
import org.apache.hive.druid.com.google.common.collect.ImmutableBiMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableListMultimap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultiset;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.ImmutableSetMultimap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedMultiset;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedSet;
import org.apache.hive.druid.com.google.common.collect.LinkedHashMultimap;
import org.apache.hive.druid.com.google.common.collect.LinkedHashMultiset;
import org.apache.hive.druid.com.google.common.collect.LinkedListMultimap;
import org.apache.hive.druid.com.google.common.collect.ListMultimap;
import org.apache.hive.druid.com.google.common.collect.Multimap;
import org.apache.hive.druid.com.google.common.collect.Multiset;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.SetMultimap;
import org.apache.hive.druid.com.google.common.collect.SortedMultiset;
import org.apache.hive.druid.com.google.common.collect.SortedSetMultimap;
import org.apache.hive.druid.com.google.common.collect.Table;
import org.apache.hive.druid.com.google.common.collect.TreeMultimap;
import org.apache.hive.druid.com.google.common.collect.TreeMultiset;
import org.apache.hive.druid.com.google.common.hash.HashCode;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.com.google.common.net.InternetDomainName;

public class GuavaDeserializers
extends Deserializers.Base
implements Serializable {
    static final long serialVersionUID = 1L;
    protected BoundType _defaultBoundType;

    public GuavaDeserializers() {
        this(null);
    }

    public GuavaDeserializers(BoundType defaultBoundType) {
        this._defaultBoundType = defaultBoundType;
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableCollection.class.isAssignableFrom(raw)) {
            if (ImmutableList.class.isAssignableFrom(raw)) {
                return new ImmutableListDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (ImmutableMultiset.class.isAssignableFrom(raw)) {
                if (ImmutableSortedMultiset.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedMultiset");
                    return new ImmutableSortedMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
                }
                return new ImmutableMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (ImmutableSet.class.isAssignableFrom(raw)) {
                if (ImmutableSortedSet.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedSet");
                    return new ImmutableSortedSetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
                }
                return new ImmutableSetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            return new ImmutableListDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
        }
        if (Multiset.class.isAssignableFrom(raw)) {
            if (SortedMultiset.class.isAssignableFrom(raw)) {
                if (TreeMultiset.class.isAssignableFrom(raw)) {
                    return new TreeMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
                }
                return new TreeMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (LinkedHashMultiset.class.isAssignableFrom(raw)) {
                return new LinkedHashMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (HashMultiset.class.isAssignableFrom(raw)) {
                return new HashMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (EnumMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultisetDeserializer(type, elementDeserializer, elementTypeDeserializer, null, null);
        }
        return null;
    }

    private void requireCollectionOfComparableElements(CollectionType actualType, String targetType) {
        Class<?> elemType = actualType.getContentType().getRawClass();
        if (!Comparable.class.isAssignableFrom(elemType)) {
            throw new IllegalArgumentException("Can not handle " + targetType + " with elements that are not Comparable<?> (" + elemType.getName() + ")");
        }
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer valueTypeDeserializer, JsonDeserializer<?> valueDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(raw)) {
            if (ImmutableSortedMap.class.isAssignableFrom(raw)) {
                return new ImmutableSortedMapDeserializer(type, keyDeserializer, valueDeserializer, valueTypeDeserializer, null);
            }
            if (ImmutableBiMap.class.isAssignableFrom(raw)) {
                return new ImmutableBiMapDeserializer(type, keyDeserializer, valueDeserializer, valueTypeDeserializer, null);
            }
            return new ImmutableMapDeserializer(type, keyDeserializer, valueDeserializer, valueTypeDeserializer, null);
        }
        if (BiMap.class.isAssignableFrom(raw)) {
            if (EnumBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (EnumHashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (HashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ListMultimap.class.isAssignableFrom(raw)) {
            if (ImmutableListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (ArrayListMultimap.class.isAssignableFrom(raw)) {
                return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedListMultimap.class.isAssignableFrom(raw)) {
                return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (SetMultimap.class.isAssignableFrom(raw)) {
            if (SortedSetMultimap.class.isAssignableFrom(raw)) {
                if (TreeMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
                if (ForwardingSortedSetMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
            }
            if (ImmutableSetMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (HashMultimap.class.isAssignableFrom(raw)) {
                return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedHashMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingSetMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Table.class.isAssignableFrom(raw)) {
            // empty if block
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) {
        if (refType.hasRawClass(Optional.class)) {
            return new GuavaOptionalDeserializer(refType, null, contentTypeDeserializer, contentDeserializer);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        if (type.hasRawClass(RangeSet.class)) {
            return new RangeSetDeserializer();
        }
        if (type.hasRawClass(Range.class)) {
            return new RangeDeserializer(this._defaultBoundType, type);
        }
        if (type.hasRawClass(HostAndPort.class)) {
            return HostAndPortDeserializer.std;
        }
        if (type.hasRawClass(InternetDomainName.class)) {
            return InternetDomainNameDeserializer.std;
        }
        if (type.hasRawClass(HashCode.class)) {
            return HashCodeDeserializer.std;
        }
        return null;
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig config, Class<?> valueType) {
        if (valueType.getName().startsWith("com.google.")) {
            return valueType == Optional.class || valueType == RangeSet.class || valueType == HostAndPort.class || valueType == InternetDomainName.class || valueType == HashCode.class || Multiset.class.isAssignableFrom(valueType) || Multimap.class.isAssignableFrom(valueType) || ImmutableCollection.class.isAssignableFrom(valueType) || ImmutableMap.class.isAssignableFrom(valueType) || BiMap.class.isAssignableFrom(valueType);
        }
        return false;
    }
}

