/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import org.joda.time.ReadablePeriod;

public class PeriodSerializer
extends JodaSerializerBase<ReadablePeriod>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JacksonJodaPeriodFormat _format;

    public PeriodSerializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    protected PeriodSerializer(JacksonJodaPeriodFormat format) {
        super(ReadablePeriod.class);
        this._format = format;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value ann;
        if (property != null && (ann = this.findFormatOverrides(prov, property, this.handledType())) != null) {
            JacksonJodaPeriodFormat format = this._format;
            Boolean useTimestamp = ann.getShape().isNumeric() ? Boolean.TRUE : (ann.getShape() == JsonFormat.Shape.STRING ? Boolean.FALSE : (ann.getShape() == JsonFormat.Shape.ARRAY ? Boolean.TRUE : null));
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            format = format.withFormat(ann.getPattern());
            if ((format = format.withLocale(ann.getLocale())) != this._format) {
                return new PeriodSerializer(format);
            }
        }
        return this;
    }

    @Override
    public void serialize(ReadablePeriod value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this._format.createFormatter(provider).print(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
        if (v2 != null) {
            // empty if block
        }
    }
}

