/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.concurrent;

import java.util.concurrent.ThreadFactory;
import org.apache.hive.druid.com.google.common.base.Function;

public class FunctionalThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;

    public FunctionalThreadFactory(final String name) {
        this(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, name);
            }
        });
    }

    public FunctionalThreadFactory(ThreadFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    public FunctionalThreadFactory transform(Function<ThreadFactory, ThreadFactory> fn) {
        return new FunctionalThreadFactory(fn.apply(this.delegate));
    }

    public FunctionalThreadFactory transformThread(final Function<Thread, Thread> fn) {
        return new FunctionalThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return (Thread)fn.apply(FunctionalThreadFactory.this.delegate.newThread(runnable));
            }
        });
    }

    public FunctionalThreadFactory daemonize() {
        return this.transformThread(new Function<Thread, Thread>(){

            @Override
            public Thread apply(Thread input) {
                input.setDaemon(true);
                return input;
            }
        });
    }
}

