/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEvent;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEventBuilder;
import org.joda.time.DateTime;

public class AlertEvent
implements ServiceEvent {
    private final String service;
    private final String host;
    private final Severity severity;
    private final String description;
    private final DateTime createdTime;
    private final Map<String, Object> dataMap;

    public AlertEvent(DateTime createdTime, String service, String host, Severity severity, String description, Map<String, Object> dataMap) {
        this.createdTime = createdTime;
        this.service = service;
        this.host = host;
        this.severity = severity;
        this.description = description;
        this.dataMap = dataMap;
    }

    public AlertEvent(String service, String host, Severity severity, String description, Map<String, Object> dataMap) {
        this(new DateTime(), service, host, severity, description, dataMap);
    }

    public AlertEvent(String service, String host, String description, Map<String, Object> dataMap) {
        this(new DateTime(), service, host, Severity.DEFAULT, description, dataMap);
    }

    public AlertEvent(String service, String host, String description) {
        this(new DateTime(), service, host, Severity.DEFAULT, description, ImmutableMap.of());
    }

    @Override
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getFeed() {
        return "alerts";
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getDataMap() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    @Override
    public boolean isSafeToBuffer() {
        return false;
    }

    @Override
    @JsonValue
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put("feed", this.getFeed()).put("timestamp", this.createdTime.toString()).put("service", this.service).put("host", this.host).put("severity", this.severity.toString()).put("description", this.description).put("data", (String)((Object)this.dataMap)).build();
    }

    @Deprecated
    public static class Builder {
        private final Map<String, Object> dataMap = new HashMap<String, Object>();

        public Builder addData(String identifier, String value) {
            this.dataMap.put(identifier, value);
            return this;
        }

        @Deprecated
        public ServiceEventBuilder<AlertEvent> build(String description) {
            return this.build(Severity.DEFAULT, description, this.dataMap);
        }

        @Deprecated
        public ServiceEventBuilder<AlertEvent> build(String description, Map<String, Object> dataMap) {
            return this.build(Severity.DEFAULT, description, dataMap);
        }

        @Deprecated
        public ServiceEventBuilder<AlertEvent> build(Severity severity, String description) {
            return this.build(severity, description, this.dataMap);
        }

        @Deprecated
        public ServiceEventBuilder<AlertEvent> build(final Severity severity, final String description, final Map<String, Object> dataMap) {
            return new ServiceEventBuilder<AlertEvent>(){

                @Override
                public AlertEvent build(String service, String host) {
                    return new AlertEvent(service, host, severity, description, dataMap);
                }
            };
        }
    }

    public static enum Severity {
        ANOMALY{

            public String toString() {
                return "anomaly";
            }
        }
        ,
        COMPONENT_FAILURE{

            public String toString() {
                return "component-failure";
            }
        }
        ,
        SERVICE_FAILURE{

            public String toString() {
                return "service-failure";
            }
        };

        public static final Severity DEFAULT;

        static {
            DEFAULT = COMPONENT_FAILURE;
        }
    }
}

