/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.metrics;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.com.metamx.metrics.KeyedDiff;
import org.apache.hive.druid.com.metamx.metrics.MonitorUtils;

public class JvmMonitor
extends AbstractMonitor {
    private final KeyedDiff gcDiff = new KeyedDiff();
    private Map<String, String[]> dimensions;

    public JvmMonitor() {
        this(ImmutableMap.of());
    }

    public JvmMonitor(Map<String, String[]> dimensions) {
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        MemoryUsage usage;
        String kind;
        ImmutableMap<String, MemoryUsage> usages = ImmutableMap.of("heap", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), "nonheap", ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        for (Map.Entry entry : usages.entrySet()) {
            kind = (String)entry.getKey();
            usage = (MemoryUsage)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("memKind", kind);
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/mem/max", usage.getMax()));
            emitter.emit(builder.build("jvm/mem/committed", usage.getCommitted()));
            emitter.emit(builder.build("jvm/mem/used", usage.getUsed()));
            emitter.emit(builder.build("jvm/mem/init", usage.getInit()));
        }
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            kind = memoryPoolMXBean.getType() == MemoryType.HEAP ? "heap" : "nonheap";
            usage = memoryPoolMXBean.getUsage();
            builder = new ServiceMetricEvent.Builder().setDimension("poolKind", kind).setDimension("poolName", memoryPoolMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/pool/max", usage.getMax()));
            emitter.emit(builder.build("jvm/pool/committed", usage.getCommitted()));
            emitter.emit(builder.build("jvm/pool/used", usage.getUsed()));
            emitter.emit(builder.build("jvm/pool/init", usage.getInit()));
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            Map<String, Long> diff = this.gcDiff.to(garbageCollectorMXBean.getName(), ImmutableMap.of("jvm/gc/time", garbageCollectorMXBean.getCollectionTime(), "jvm/gc/count", garbageCollectorMXBean.getCollectionCount()));
            if (diff == null) continue;
            ServiceMetricEvent.Builder builder2 = new ServiceMetricEvent.Builder().setDimension("gcName", garbageCollectorMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder2, this.dimensions);
            for (Map.Entry<String, Long> entry : diff.entrySet()) {
                emitter.emit(builder2.build(entry.getKey(), entry.getValue()));
            }
        }
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            ServiceMetricEvent.Builder builder3 = new ServiceMetricEvent.Builder().setDimension("bufferpoolName", bufferPoolMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder3, this.dimensions);
            emitter.emit(builder3.build("jvm/bufferpool/capacity", bufferPoolMXBean.getTotalCapacity()));
            emitter.emit(builder3.build("jvm/bufferpool/used", bufferPoolMXBean.getMemoryUsed()));
            emitter.emit(builder3.build("jvm/bufferpool/count", bufferPoolMXBean.getCount()));
        }
        return true;
    }
}

