/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.com.metamx.metrics.KeyedDiff;
import org.apache.hive.druid.com.metamx.metrics.MonitorUtils;
import org.apache.hive.druid.com.metamx.metrics.SigarUtil;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.NetStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Tcp;
import org.hyperic.sigar.Uptime;

public class SysMonitor
extends AbstractMonitor {
    private static final Logger log = new Logger(SysMonitor.class);
    private final Sigar sigar = SigarUtil.getSigar();
    private final List<String> fsTypeWhitelist = ImmutableList.of("local");
    private final List<String> netAddressBlacklist = ImmutableList.of("0.0.0.0", "127.0.0.1");
    private final List<Stats> statsList;
    private Map<String, String[]> dimensions;

    public SysMonitor() {
        this(ImmutableMap.of());
    }

    public SysMonitor(Map<String, String[]> dimensions) {
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.statsList = new ArrayList<Stats>();
        this.statsList.addAll(Arrays.asList(new MemStats(), new FsStats(), new DiskStats(), new NetStats(), new CpuStats(), new SwapStats(), new SysStats(), new TcpStats()));
    }

    public void addDirectoriesToMonitor(String[] dirList) {
        for (int i = 0; i < dirList.length; ++i) {
            dirList[i] = dirList[i].trim();
        }
        this.statsList.add(new DirStats(dirList));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        for (Stats stats : this.statsList) {
            stats.emit(emitter);
        }
        return true;
    }

    private class TcpStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private TcpStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Map<String, Long> stats;
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
            Tcp tcp = null;
            try {
                tcp = SysMonitor.this.sigar.getTcp();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Tcp", new Object[0]);
            }
            if (tcp != null && (stats = this.diff.to("tcp", ImmutableMap.builder().put("sys/tcp/activeOpens", tcp.getActiveOpens()).put("sys/tcp/passiveOpens", tcp.getPassiveOpens()).put("sys/tcp/attemptFails", tcp.getAttemptFails()).put("sys/tcp/estabResets", tcp.getEstabResets()).put("sys/tcp/in/segs", tcp.getInSegs()).put("sys/tcp/in/errs", tcp.getInErrs()).put("sys/tcp/out/segs", tcp.getOutSegs()).put("sys/tcp/out/rsts", tcp.getOutRsts()).put("sys/tcp/retrans/segs", tcp.getRetransSegs()).build())) != null) {
                for (Map.Entry<String, Long> entry : stats.entrySet()) {
                    emitter.emit(builder.build(entry.getKey(), entry.getValue()));
                }
            }
            NetStat netStat = null;
            try {
                netStat = SysMonitor.this.sigar.getNetStat();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get NetStat", new Object[0]);
            }
            if (netStat != null) {
                ImmutableMap<String, Long> stats2 = ImmutableMap.builder().put("sys/net/inbound", Long.valueOf(netStat.getAllInboundTotal())).put("sys/net/outbound", Long.valueOf(netStat.getAllOutboundTotal())).put("sys/tcp/inbound", Long.valueOf(netStat.getTcpInboundTotal())).put("sys/tcp/outbound", Long.valueOf(netStat.getTcpOutboundTotal())).put("sys/tcp/state/established", Long.valueOf(netStat.getTcpEstablished())).put("sys/tcp/state/synSent", Long.valueOf(netStat.getTcpSynSent())).put("sys/tcp/state/synRecv", Long.valueOf(netStat.getTcpSynRecv())).put("sys/tcp/state/finWait1", Long.valueOf(netStat.getTcpFinWait1())).put("sys/tcp/state/finWait2", Long.valueOf(netStat.getTcpFinWait2())).put("sys/tcp/state/timeWait", Long.valueOf(netStat.getTcpTimeWait())).put("sys/tcp/state/close", Long.valueOf(netStat.getTcpClose())).put("sys/tcp/state/closeWait", Long.valueOf(netStat.getTcpCloseWait())).put("sys/tcp/state/lastAck", Long.valueOf(netStat.getTcpLastAck())).put("sys/tcp/state/listen", Long.valueOf(netStat.getTcpListen())).put("sys/tcp/state/closing", Long.valueOf(netStat.getTcpClosing())).put("sys/tcp/state/idle", Long.valueOf(netStat.getTcpIdle())).put("sys/tcp/state/bound", Long.valueOf(netStat.getTcpBound())).build();
                for (Map.Entry entry : stats2.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class SysStats
    implements Stats {
        private SysStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            ImmutableMap<String, Number> stats;
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
            Uptime uptime = null;
            try {
                uptime = SysMonitor.this.sigar.getUptime();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Uptime", new Object[0]);
            }
            double[] la = null;
            try {
                la = SysMonitor.this.sigar.getLoadAverage();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Load Average", new Object[0]);
            }
            if (uptime != null) {
                stats = ImmutableMap.of("sys/uptime", Double.valueOf(uptime.getUptime()).longValue());
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
            if (la != null) {
                stats = ImmutableMap.of("sys/la/1", la[0], "sys/la/5", la[1], "sys/la/15", la[2]);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class CpuStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private CpuStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] cpus = null;
            try {
                cpus = SysMonitor.this.sigar.getCpuList();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Cpu list", new Object[0]);
            }
            if (cpus != null) {
                log.debug("Found Cpu list: [%s]", Joiner.on(", ").join(cpus));
                for (int i = 0; i < cpus.length; ++i) {
                    Object cpu = cpus[i];
                    String name = Integer.toString(i);
                    Map<String, Long> stats = this.diff.to(name, ImmutableMap.builder().put("user", cpu.getUser()).put("sys", cpu.getSys()).put("nice", cpu.getNice()).put("wait", cpu.getWait()).put("irq", cpu.getIrq()).put("softIrq", cpu.getSoftIrq()).put("stolen", cpu.getStolen()).put("_total", cpu.getTotal()).build());
                    if (stats == null) continue;
                    long total = stats.remove("_total");
                    for (Map.Entry<String, Long> entry : stats.entrySet()) {
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("cpuName", name).setDimension("cpuTime", entry.getKey());
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        emitter.emit(builder.build("sys/cpu", entry.getValue() * 100L / total));
                    }
                }
            }
        }
    }

    private class NetStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private NetStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] ifaces = null;
            try {
                ifaces = SysMonitor.this.sigar.getNetInterfaceList();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get NetInterface list", new Object[0]);
            }
            if (ifaces != null) {
                log.debug("Found NetInterface list: [%s]", Joiner.on(", ").join(ifaces));
                for (Object name : ifaces) {
                    NetInterfaceConfig netconf = null;
                    try {
                        netconf = SysMonitor.this.sigar.getNetInterfaceConfig((String)name);
                    }
                    catch (SigarException e) {
                        log.error(e, "Failed to get NetInterfaceConfig[%s]", name);
                    }
                    if (netconf == null) continue;
                    if (!SysMonitor.this.netAddressBlacklist.contains(netconf.getAddress())) {
                        Map<String, Long> stats;
                        NetInterfaceStat netstat = null;
                        try {
                            netstat = SysMonitor.this.sigar.getNetInterfaceStat((String)name);
                        }
                        catch (SigarException e) {
                            log.error(e, "Failed to get NetInterfaceStat[%s]", name);
                        }
                        if (netstat == null || (stats = this.diff.to((String)name, ImmutableMap.builder().put("sys/net/read/size", netstat.getRxBytes()).put("sys/net/read/packets", netstat.getRxPackets()).put("sys/net/read/errors", netstat.getRxErrors()).put("sys/net/read/dropped", netstat.getRxDropped()).put("sys/net/read/overruns", netstat.getRxOverruns()).put("sys/net/read/frame", netstat.getRxFrame()).put("sys/net/write/size", netstat.getTxBytes()).put("sys/net/write/packets", netstat.getTxPackets()).put("sys/net/write/errors", netstat.getTxErrors()).put("sys/net/write/dropped", netstat.getTxDropped()).put("sys/net/write/collisions", netstat.getTxCollisions()).put("sys/net/write/overruns", netstat.getTxOverruns()).build())) == null) continue;
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("netName", netconf.getName()).setDimension("netAddress", netconf.getAddress()).setDimension("netHwaddr", netconf.getHwaddr());
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        for (Map.Entry<String, Long> entry : stats.entrySet()) {
                            emitter.emit(builder.build(entry.getKey(), entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring net stats for name[%s] with address[%s]", name, netconf.getAddress());
                }
            }
        }
    }

    private class DiskStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private DiskStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] fss = null;
            try {
                fss = SysMonitor.this.sigar.getFileSystemList();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get FileSystem list", new Object[0]);
            }
            if (fss != null) {
                log.debug("Found FileSystem list: [%s]", Joiner.on(", ").join(fss));
                for (Object fs : fss) {
                    String name = fs.getDevName();
                    if (SysMonitor.this.fsTypeWhitelist.contains(fs.getTypeName())) {
                        Map<String, Long> stats;
                        DiskUsage du = null;
                        try {
                            du = SysMonitor.this.sigar.getDiskUsage(name);
                        }
                        catch (SigarException e) {
                            log.error(e, "Failed to get DiskUsage[%s]", name);
                        }
                        if (du == null || (stats = this.diff.to(name, ImmutableMap.builder().put("sys/disk/read/size", du.getReadBytes()).put("sys/disk/read/count", du.getReads()).put("sys/disk/write/size", du.getWriteBytes()).put("sys/disk/write/count", du.getWrites()).put("sys/disk/queue", Double.valueOf(du.getQueue()).longValue()).put("sys/disk/serviceTime", Double.valueOf(du.getServiceTime()).longValue()).build())) == null) continue;
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("fsDevName", fs.getDevName()).setDimension("fsDirName", fs.getDirName()).setDimension("fsTypeName", fs.getTypeName()).setDimension("fsSysTypeName", fs.getSysTypeName()).setDimension("fsOptions", fs.getOptions().split(","));
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        for (Map.Entry<String, Long> entry : stats.entrySet()) {
                            emitter.emit(builder.build(entry.getKey(), entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring disk stats for name[%s] with typeName[%s]", name, fs.getTypeName());
                }
            }
        }
    }

    private class FsStats
    implements Stats {
        private FsStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] fss = null;
            try {
                fss = SysMonitor.this.sigar.getFileSystemList();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get FileSystem list", new Object[0]);
            }
            if (fss != null) {
                log.debug("Found FileSystem list: [%s]", Joiner.on(", ").join(fss));
                for (Object fs : fss) {
                    String name = fs.getDirName();
                    if (SysMonitor.this.fsTypeWhitelist.contains(fs.getTypeName())) {
                        FileSystemUsage fsu = null;
                        try {
                            fsu = SysMonitor.this.sigar.getFileSystemUsage(name);
                        }
                        catch (SigarException e) {
                            log.error(e, "Failed to get FileSystemUsage[%s]", name);
                        }
                        if (fsu == null) continue;
                        ImmutableMap<String, Long> stats = ImmutableMap.builder().put("sys/fs/max", fsu.getTotal() * 1024L).put("sys/fs/used", fsu.getUsed() * 1024L).put("sys/fs/files/count", fsu.getFiles()).put("sys/fs/files/free", fsu.getFreeFiles()).build();
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("fsDevName", fs.getDevName()).setDimension("fsDirName", fs.getDirName()).setDimension("fsTypeName", fs.getTypeName()).setDimension("fsSysTypeName", fs.getSysTypeName()).setDimension("fsOptions", fs.getOptions().split(","));
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        for (Map.Entry entry : stats.entrySet()) {
                            emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring fs stats for name[%s] with typeName[%s]", name, fs.getTypeName());
                }
            }
        }
    }

    private class DirStats
    implements Stats {
        private final String[] dirList;

        private DirStats(String[] dirList) {
            this.dirList = dirList;
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            for (String dir : this.dirList) {
                DirUsage du = null;
                try {
                    du = SysMonitor.this.sigar.getDirUsage(dir);
                }
                catch (SigarException e) {
                    log.error("Failed to get DiskUsage for [%s] due to   [%s]", dir, e.getMessage());
                }
                if (du == null) continue;
                ImmutableMap<String, Long> stats = ImmutableMap.of("sys/storage/used", du.getDiskUsage());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("fsDirName", dir);
                MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class SwapStats
    implements Stats {
        private long prevPageIn = 0L;
        private long prevPageOut = 0L;

        private SwapStats() {
            try {
                Swap swap = SysMonitor.this.sigar.getSwap();
                this.prevPageIn = swap.getPageIn();
                this.prevPageOut = swap.getPageOut();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Swap", new Object[0]);
            }
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Swap swap = null;
            try {
                swap = SysMonitor.this.sigar.getSwap();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Swap", new Object[0]);
            }
            if (swap != null) {
                long currPageIn = swap.getPageIn();
                long currPageOut = swap.getPageOut();
                ImmutableMap<String, Long> stats = ImmutableMap.of("sys/swap/pageIn", currPageIn - this.prevPageIn, "sys/swap/pageOut", currPageOut - this.prevPageOut, "sys/swap/max", swap.getTotal(), "sys/swap/free", swap.getFree());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
                this.prevPageIn = currPageIn;
                this.prevPageOut = currPageOut;
            }
        }
    }

    private class MemStats
    implements Stats {
        private MemStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Mem mem = null;
            try {
                mem = SysMonitor.this.sigar.getMem();
            }
            catch (SigarException e) {
                log.error(e, "Failed to get Mem", new Object[0]);
            }
            if (mem != null) {
                ImmutableMap<String, Long> stats = ImmutableMap.of("sys/mem/max", mem.getTotal(), "sys/mem/used", mem.getUsed(), "sys/mem/actual/used", mem.getActualUsed(), "sys/mem/actual/free", mem.getActualFree());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private static interface Stats {
        public void emit(ServiceEmitter var1);
    }
}

