/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.MapMaker;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.InventoryView;
import org.apache.hive.druid.io.druid.client.ServerView;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.curator.inventory.CuratorInventoryManager;
import org.apache.hive.druid.io.druid.curator.inventory.CuratorInventoryManagerStrategy;
import org.apache.hive.druid.io.druid.curator.inventory.InventoryManagerConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public abstract class ServerInventoryView<InventoryType>
implements ServerView,
InventoryView {
    private final EmittingLogger log;
    private final CuratorInventoryManager<DruidServer, InventoryType> inventoryManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ConcurrentMap<ServerView.ServerCallback, Executor> serverCallbacks = new MapMaker().makeMap();
    private final ConcurrentMap<ServerView.SegmentCallback, Executor> segmentCallbacks = new MapMaker().makeMap();

    public ServerInventoryView(final EmittingLogger log, final String announcementsPath, final String inventoryPath, CuratorFramework curator, final ObjectMapper jsonMapper, final TypeReference<InventoryType> typeReference) {
        this.log = log;
        this.inventoryManager = new CuratorInventoryManager(curator, new InventoryManagerConfig(){

            @Override
            public String getContainerPath() {
                return announcementsPath;
            }

            @Override
            public String getInventoryPath() {
                return inventoryPath;
            }
        }, Execs.singleThreaded("ServerInventoryView-%s"), new CuratorInventoryManagerStrategy<DruidServer, InventoryType>(){

            @Override
            public DruidServer deserializeContainer(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, DruidServer.class);
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public InventoryType deserializeInventory(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, typeReference);
                }
                catch (IOException e) {
                    CharBuffer.wrap(StringUtils.fromUtf8(bytes).toCharArray());
                    CharBuffer charBuffer = Charsets.UTF_8.decode(ByteBuffer.wrap(bytes));
                    log.error(e, "Could not parse json: %s", charBuffer.toString());
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public void newContainer(DruidServer container) {
                log.info("New Server[%s]", container);
            }

            @Override
            public void deadContainer(DruidServer deadContainer) {
                log.info("Server Disappeared[%s]", deadContainer);
                ServerInventoryView.this.runServerCallbacks(deadContainer);
            }

            @Override
            public DruidServer updateContainer(DruidServer oldContainer, DruidServer newContainer) {
                return newContainer.addDataSegments(oldContainer);
            }

            @Override
            public DruidServer addInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return ServerInventoryView.this.addInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer updateInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return ServerInventoryView.this.updateInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer removeInventory(DruidServer container, String inventoryKey) {
                return ServerInventoryView.this.removeInnerInventory(container, inventoryKey);
            }

            @Override
            public void inventoryInitialized() {
                log.info("Inventory Initialized", new Object[0]);
                ServerInventoryView.this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

                    @Override
                    public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                        return input.segmentViewInitialized();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                this.inventoryManager.start();
                this.started.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.getAndSet(false)) {
                this.inventoryManager.stop();
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public DruidServer getInventoryValue(String containerKey) {
        return this.inventoryManager.getInventoryValue(containerKey);
    }

    @Override
    public Iterable<DruidServer> getInventory() {
        return this.inventoryManager.getInventory();
    }

    @Override
    public void registerServerCallback(Executor exec, ServerView.ServerCallback callback) {
        this.serverCallbacks.put(callback, exec);
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        this.segmentCallbacks.put(callback, exec);
    }

    public InventoryManagerConfig getInventoryManagerConfig() {
        return this.inventoryManager.getConfig();
    }

    protected void runSegmentCallbacks(final Function<ServerView.SegmentCallback, ServerView.CallbackAction> fn) {
        for (final Map.Entry entry : this.segmentCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == fn.apply(entry.getKey())) {
                        ServerInventoryView.this.segmentCallbackRemoved((ServerView.SegmentCallback)entry.getKey());
                        ServerInventoryView.this.segmentCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    protected void runServerCallbacks(final DruidServer server) {
        for (final Map.Entry entry : this.serverCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == ((ServerView.ServerCallback)entry.getKey()).serverRemoved(server)) {
                        ServerInventoryView.this.serverCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    protected void addSingleInventory(final DruidServer container, final DataSegment inventory) {
        this.log.debug("Server[%s] added segment[%s]", container.getName(), inventory.getIdentifier());
        if (container.getSegment(inventory.getIdentifier()) != null) {
            this.log.warn("Not adding or running callbacks for existing segment[%s] on server[%s]", inventory.getIdentifier(), container.getName());
            return;
        }
        container.addDataSegment(inventory.getIdentifier(), inventory);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            @Override
            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentAdded(container.getMetadata(), inventory);
            }
        });
    }

    protected void removeSingleInventory(final DruidServer container, String inventoryKey) {
        this.log.debug("Server[%s] removed segment[%s]", container.getName(), inventoryKey);
        final DataSegment segment = container.getSegment(inventoryKey);
        if (segment == null) {
            this.log.warn("Not running cleanup or callbacks for non-existing segment[%s] on server[%s]", inventoryKey, container.getName());
            return;
        }
        container.removeDataSegment(inventoryKey);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            @Override
            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentRemoved(container.getMetadata(), segment);
            }
        });
    }

    protected abstract DruidServer addInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer updateInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer removeInnerInventory(DruidServer var1, String var2);

    protected abstract void segmentCallbackRemoved(ServerView.SegmentCallback var1);
}

