/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.LinkedOperationQueueFactory;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheStats;
import org.apache.hive.druid.io.druid.client.cache.LZ4Transcoder;
import org.apache.hive.druid.io.druid.client.cache.MemcachedCacheConfig;
import org.apache.hive.druid.io.druid.client.cache.MemcachedCustomConnectionFactoryBuilder;
import org.apache.hive.druid.io.druid.client.cache.MemcachedOperationQueueFactory;
import org.apache.hive.druid.io.druid.collections.LoadBalancingPool;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidResourceHolder;

public class MemcachedCache
implements Cache {
    private static final Logger log = new Logger(MemcachedCache.class);
    static final HashAlgorithm MURMUR3_128 = new HashAlgorithm(){
        final HashFunction fn = Hashing.murmur3_128();

        public long hash(String k) {
            return this.fn.hashString(k, Charsets.UTF_8).asLong();
        }

        public String toString() {
            return this.fn.toString();
        }
    };
    private final int timeout;
    private final int expiration;
    private final String memcachedPrefix;
    private final Supplier<ResourceHolder<MemcachedClientIF>> client;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong timeoutCount = new AtomicLong(0L);
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AbstractMonitor monitor;
    public static final int MAX_PREFIX_LENGTH = 168;

    public static MemcachedCache create(MemcachedCacheConfig config) {
        final ConcurrentHashMap counters = new ConcurrentHashMap();
        final ConcurrentHashMap meters = new ConcurrentHashMap();
        AbstractMonitor monitor = new AbstractMonitor(){
            final AtomicReference<Map<String, Long>> priorValues = new AtomicReference(new HashMap());

            @Override
            public boolean doMonitor(ServiceEmitter emitter) {
                Map<String, Long> priorValues = this.priorValues.get();
                Map<String, Long> currentValues = this.getCurrentValues();
                ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder();
                for (Map.Entry<String, Long> entry : currentValues.entrySet()) {
                    emitter.emit(builder.setDimension("memcached metric", entry.getKey()).build("query/cache/memcached/total", entry.getValue()));
                    Long prior = priorValues.get(entry.getKey());
                    if (prior == null) continue;
                    emitter.emit(builder.setDimension("memcached metric", entry.getKey()).build("query/cache/memcached/delta", entry.getValue() - prior));
                }
                if (!this.priorValues.compareAndSet(priorValues, currentValues)) {
                    log.error("Prior value changed while I was reporting! updating anyways", new Object[0]);
                    this.priorValues.set(currentValues);
                }
                return true;
            }

            private Map<String, Long> getCurrentValues() {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : counters.entrySet()) {
                    builder.put(entry.getKey(), ((AtomicLong)entry.getValue()).get());
                }
                for (Map.Entry entry : meters.entrySet()) {
                    builder.put(entry.getKey(), ((AtomicLong)entry.getValue()).get());
                }
                return builder.build();
            }
        };
        try {
            LZ4Transcoder transcoder = new LZ4Transcoder(config.getMaxObjectSize());
            transcoder.setCompressionThreshold(0);
            long maxQueueBytes = config.getMaxOperationQueueSize();
            Object opQueueFactory = maxQueueBytes > 0L ? new MemcachedOperationQueueFactory(maxQueueBytes) : new LinkedOperationQueueFactory();
            final Predicate<String> interesting = new Predicate<String>(){
                private final Set<String> interestingMetrics = ImmutableSet.of("[MEM] Reconnecting Nodes (ReconnectQueue)", "[MEM] Request Rate: All", "[MEM] Average Bytes written to OS per write", "[MEM] Average Bytes read from OS per read", "[MEM] Average Time on wire for operations (\u00b5s)", "[MEM] Response Rate: All (Failure + Success + Retry)", new String[]{"[MEM] Response Rate: Retry", "[MEM] Response Rate: Failure", "[MEM] Response Rate: Success"});

                @Override
                public boolean apply(@Nullable String input) {
                    return input != null && this.interestingMetrics.contains(input);
                }
            };
            MetricCollector metricCollector = new MetricCollector(){

                public void addCounter(String name) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    counters.putIfAbsent(name, new AtomicLong(0L));
                    if (log.isDebugEnabled()) {
                        log.debug("Add Counter [%s]", name);
                    }
                }

                public void removeCounter(String name) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring request to remove [%s]", name);
                    }
                }

                public void incrementCounter(String name) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)counters.get(name);
                    if (counter == null) {
                        counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)counters.get(name);
                    }
                    counter.incrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Increment [%s]", name);
                    }
                }

                public void incrementCounter(String name, int amount) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)counters.get(name);
                    if (counter == null) {
                        counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)counters.get(name);
                    }
                    counter.addAndGet(amount);
                    if (log.isDebugEnabled()) {
                        log.debug("Increment [%s] %d", name, amount);
                    }
                }

                public void decrementCounter(String name) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)counters.get(name);
                    if (counter == null) {
                        counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)counters.get(name);
                    }
                    counter.decrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Decrement [%s]", name);
                    }
                }

                public void decrementCounter(String name, int amount) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    AtomicLong counter = (AtomicLong)counters.get(name);
                    if (counter == null) {
                        counters.putIfAbsent(name, new AtomicLong(0L));
                        counter = (AtomicLong)counters.get(name);
                    }
                    counter.addAndGet(-amount);
                    if (log.isDebugEnabled()) {
                        log.debug("Decrement [%s] %d", name, amount);
                    }
                }

                public void addMeter(String name) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    meters.putIfAbsent(name, new AtomicLong(0L));
                    if (log.isDebugEnabled()) {
                        log.debug("Adding meter [%s]", name);
                    }
                }

                public void removeMeter(String name) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring request to remove meter [%s]", name);
                    }
                }

                public void markMeter(String name) {
                    if (!interesting.apply(name)) {
                        return;
                    }
                    AtomicLong meter = (AtomicLong)meters.get(name);
                    if (meter == null) {
                        meters.putIfAbsent(name, new AtomicLong(0L));
                        meter = (AtomicLong)meters.get(name);
                    }
                    meter.incrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Increment counter [%s]", name);
                    }
                }

                public void addHistogram(String name) {
                    log.debug("Ignoring add histogram [%s]", name);
                }

                public void removeHistogram(String name) {
                    log.debug("Ignoring remove histogram [%s]", name);
                }

                public void updateHistogram(String name, int amount) {
                    log.debug("Ignoring update histogram [%s]: %d", name, amount);
                }
            };
            final ConnectionFactory connectionFactory = new MemcachedCustomConnectionFactoryBuilder().setKetamaNodeRepetitions(1000).setHashAlg(MURMUR3_128).setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setLocatorType(ConnectionFactoryBuilder.Locator.CONSISTENT).setDaemon(true).setFailureMode(FailureMode.Cancel).setTranscoder((Transcoder)transcoder).setShouldOptimize(true).setOpQueueMaxBlockTime((long)config.getTimeout()).setOpTimeout((long)config.getTimeout()).setReadBufferSize(config.getReadBufferSize()).setOpQueueFactory((OperationQueueFactory)opQueueFactory).setMetricCollector(metricCollector).setEnableMetrics(MetricType.DEBUG).build();
            final List hosts = AddrUtil.getAddresses((String)config.getHosts());
            Supplier<ResourceHolder<Object>> clientSupplier = config.getNumConnections() > 1 ? new LoadBalancingPool<MemcachedClientIF>(config.getNumConnections(), new Supplier<MemcachedClientIF>(){

                @Override
                public MemcachedClientIF get() {
                    try {
                        return new MemcachedClient(connectionFactory, hosts);
                    }
                    catch (IOException e) {
                        log.error(e, "Unable to create memcached client", new Object[0]);
                        throw Throwables.propagate(e);
                    }
                }
            }) : Suppliers.ofInstance(StupidResourceHolder.create(new MemcachedClient(connectionFactory, hosts)));
            return new MemcachedCache(clientSupplier, config, monitor);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    MemcachedCache(Supplier<ResourceHolder<MemcachedClientIF>> client, MemcachedCacheConfig config, AbstractMonitor monitor) {
        Preconditions.checkArgument(config.getMemcachedPrefix().length() <= 168, "memcachedPrefix length [%d] exceeds maximum length [%d]", config.getMemcachedPrefix().length(), 168);
        this.monitor = monitor;
        this.timeout = config.getTimeout();
        this.expiration = config.getExpiration();
        this.client = client;
        this.memcachedPrefix = config.getMemcachedPrefix();
    }

    @Override
    public CacheStats getStats() {
        return new CacheStats(this.hitCount.get(), this.missCount.get(), 0L, 0L, 0L, this.timeoutCount.get(), this.errorCount.get());
    }

    @Override
    public byte[] get(Cache.NamedKey key) {
        try (ResourceHolder<MemcachedClientIF> clientHolder = this.client.get();){
            Future future;
            try {
                future = clientHolder.get().asyncGet(MemcachedCache.computeKeyHash(this.memcachedPrefix, key));
            }
            catch (IllegalStateException e) {
                this.errorCount.incrementAndGet();
                log.warn(e, "Unable to queue cache operation", new Object[0]);
                byte[] byArray = null;
                if (clientHolder != null) {
                    if (var3_3 != null) {
                        try {
                            clientHolder.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        clientHolder.close();
                    }
                }
                return byArray;
            }
            byte[] bytes = (byte[])future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bytes != null) {
                this.hitCount.incrementAndGet();
            } else {
                this.missCount.incrementAndGet();
            }
            byte[] byArray = bytes == null ? null : MemcachedCache.deserializeValue(key, bytes);
            return byArray;
        }
    }

    @Override
    public void put(Cache.NamedKey key, byte[] value) {
        try (ResourceHolder<MemcachedClientIF> clientHolder = this.client.get();){
            clientHolder.get().set(MemcachedCache.computeKeyHash(this.memcachedPrefix, key), this.expiration, (Object)MemcachedCache.serializeValue(key, value));
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            log.warn(e, "Unable to queue cache operation", new Object[0]);
        }
    }

    private static byte[] serializeValue(Cache.NamedKey key, byte[] value) {
        byte[] keyBytes = key.toByteArray();
        return ByteBuffer.allocate(4 + keyBytes.length + value.length).putInt(keyBytes.length).put(keyBytes).put(value).array();
    }

    private static byte[] deserializeValue(Cache.NamedKey key, byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int keyLength = buf.getInt();
        byte[] keyBytes = new byte[keyLength];
        buf.get(keyBytes);
        byte[] value = new byte[buf.remaining()];
        buf.get(value);
        Preconditions.checkState(Arrays.equals(keyBytes, key.toByteArray()), "Keys do not match, possible hash collision?");
        return value;
    }

    @Override
    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        try (ResourceHolder<MemcachedClientIF> clientHolder = this.client.get();){
            BulkFuture future;
            ImmutableMap<String, Cache.NamedKey> keyLookup = Maps.uniqueIndex(keys, new Function<Cache.NamedKey, String>(){

                @Override
                public String apply(@Nullable Cache.NamedKey input) {
                    return MemcachedCache.computeKeyHash(MemcachedCache.this.memcachedPrefix, input);
                }
            });
            HashMap<Cache.NamedKey, byte[]> results = Maps.newHashMap();
            try {
                future = clientHolder.get().asyncGetBulk(keyLookup.keySet());
            }
            catch (IllegalStateException e) {
                this.errorCount.incrementAndGet();
                log.warn(e, "Unable to queue cache operation", new Object[0]);
                HashMap<Cache.NamedKey, byte[]> hashMap = results;
                if (clientHolder != null) {
                    if (var3_3 != null) {
                        try {
                            clientHolder.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        clientHolder.close();
                    }
                }
                return hashMap;
            }
            Map some = (Map)future.getSome((long)this.timeout, TimeUnit.MILLISECONDS);
            if (future.isTimeout()) {
                future.cancel(false);
                this.timeoutCount.incrementAndGet();
            }
            this.missCount.addAndGet(keyLookup.size() - some.size());
            this.hitCount.addAndGet(some.size());
            for (Map.Entry entry : some.entrySet()) {
                Cache.NamedKey key = (Cache.NamedKey)keyLookup.get(entry.getKey());
                byte[] value = (byte[])entry.getValue();
                if (value == null) continue;
                results.put(key, MemcachedCache.deserializeValue(key, value));
            }
            HashMap<Cache.NamedKey, byte[]> hashMap = results;
            return hashMap;
        }
    }

    @Override
    public void close(String namespace) {
    }

    private static String computeKeyHash(String memcachedPrefix, Cache.NamedKey key) {
        return memcachedPrefix + ":" + DigestUtils.sha1Hex((String)key.namespace) + ":" + DigestUtils.sha1Hex((byte[])key.key);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void doMonitor(ServiceEmitter emitter) {
        this.monitor.doMonitor(emitter);
    }
}

