/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice.http;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.guice.http.DruidHttpClientConfig;

public abstract class AbstractHttpClientProvider<HttpClientType>
implements Provider<HttpClientType> {
    private final Key<Supplier<DruidHttpClientConfig>> configKey;
    private final Key<SSLContext> sslContextKey;
    private Injector injector;

    public AbstractHttpClientProvider() {
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){});
        this.sslContextKey = Key.get(SSLContext.class);
    }

    public AbstractHttpClientProvider(Annotation annotation) {
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, (Annotation)annotation);
        this.sslContextKey = Key.get(SSLContext.class, (Annotation)annotation);
    }

    public AbstractHttpClientProvider(Class<? extends Annotation> annotation) {
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, annotation);
        this.sslContextKey = Key.get(SSLContext.class, annotation);
    }

    @Inject
    public void configure(Injector injector) {
        this.injector = injector;
    }

    public Key<Supplier<DruidHttpClientConfig>> getConfigKey() {
        return this.configKey;
    }

    public Key<SSLContext> getSslContextKey() {
        return this.sslContextKey;
    }

    public Provider<Supplier<DruidHttpClientConfig>> getConfigProvider() {
        return this.injector.getProvider(this.configKey);
    }

    public Provider<Lifecycle> getLifecycleProvider() {
        return this.injector.getProvider(Lifecycle.class);
    }

    public Binding<SSLContext> getSslContextBinding() {
        return this.injector.getExistingBinding(this.sslContextKey);
    }
}

