/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;

public class QueryCacheHelper {
    public static byte[] computeAggregatorBytes(List<AggregatorFactory> aggregatorSpecs) {
        ArrayList<byte[]> cacheKeySet = Lists.newArrayListWithCapacity(aggregatorSpecs.size());
        int totalSize = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            byte[] cacheKey = spec.getCacheKey();
            cacheKeySet.add(cacheKey);
            totalSize += cacheKey.length;
        }
        ByteBuffer retVal = ByteBuffer.allocate(totalSize);
        for (byte[] bytes : cacheKeySet) {
            retVal.put(bytes);
        }
        return retVal.array();
    }
}

