/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.MergeSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.UnionDataSource;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof UnionDataSource) {
            return new MergeSequence<T>(query.getResultOrdering(), Sequences.simple(Lists.transform(((UnionDataSource)dataSource).getDataSources(), new Function<DataSource, Sequence<T>>(){

                @Override
                public Sequence<T> apply(DataSource singleSource) {
                    return UnionQueryRunner.this.baseRunner.run(query.withDataSource(singleSource), responseContext);
                }
            })));
        }
        return this.baseRunner.run(query, responseContext);
    }
}

