/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.cardinality;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregators;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;

public class CardinalityAggregatorFactory
extends AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 8;
    private static final byte CACHE_KEY_SEPARATOR = -1;
    private final String name;
    private final List<DimensionSpec> fields;
    private final boolean byRow;

    private static List<String> makeRequiredFieldNamesFromFields(List<DimensionSpec> fields) {
        return ImmutableList.copyOf(Lists.transform(fields, new Function<DimensionSpec, String>(){

            @Override
            public String apply(DimensionSpec input) {
                return input.getDimension();
            }
        }));
    }

    private static List<DimensionSpec> makeFieldsFromFieldNames(List<String> fieldNames) {
        return ImmutableList.copyOf(Lists.transform(fieldNames, new Function<String, DimensionSpec>(){

            @Override
            public DimensionSpec apply(String input) {
                return new DefaultDimensionSpec(input, input);
            }
        }));
    }

    public static Object estimateCardinality(Object object) {
        if (object == null) {
            return 0;
        }
        return ((HyperLogLogCollector)object).estimateCardinality();
    }

    @JsonCreator
    public CardinalityAggregatorFactory(@JsonProperty(value="name") String name, @Deprecated @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fields") List<DimensionSpec> fields, @JsonProperty(value="byRow") boolean byRow) {
        this.name = name;
        if (fields == null) {
            Preconditions.checkArgument(fieldNames != null, "Must provide 'fieldNames' if 'fields' is null.");
            this.fields = CardinalityAggregatorFactory.makeFieldsFromFieldNames(fieldNames);
        } else {
            Preconditions.checkArgument(fieldNames == null, "Cannot specify both 'fieldNames' and 'fields.");
            this.fields = fields;
        }
        this.byRow = byRow;
    }

    public CardinalityAggregatorFactory(String name, List<DimensionSpec> fields, boolean byRow) {
        this(name, null, fields, byRow);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        List<DimensionSelector> selectors = this.makeDimensionSelectors(columnFactory);
        if (selectors.isEmpty()) {
            return Aggregators.noopAggregator();
        }
        return new CardinalityAggregator(this.name, selectors, this.byRow);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnFactory) {
        List<DimensionSelector> selectors = this.makeDimensionSelectors(columnFactory);
        if (selectors.isEmpty()) {
            return Aggregators.noopBufferAggregator();
        }
        return new CardinalityBufferAggregator(selectors, this.byRow);
    }

    private List<DimensionSelector> makeDimensionSelectors(final ColumnSelectorFactory columnFactory) {
        return Lists.newArrayList(Iterables.filter(Iterables.transform(this.fields, new Function<DimensionSpec, DimensionSelector>(){

            @Override
            public DimensionSelector apply(DimensionSpec input) {
                return columnFactory.makeDimensionSelector(input);
            }
        }), Predicates.notNull()));
    }

    @Override
    public Comparator getComparator() {
        return new Comparator<HyperLogLogCollector>(){

            @Override
            public int compare(HyperLogLogCollector lhs, HyperLogLogCollector rhs) {
                return lhs.compareTo(rhs);
            }
        };
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        throw new UnsupportedOperationException("can't merge CardinalityAggregatorFactory");
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Lists.transform(this.fields, new Function<DimensionSpec, AggregatorFactory>(){

            @Override
            public AggregatorFactory apply(DimensionSpec input) {
                return new CardinalityAggregatorFactory(input.getOutputName(), Collections.singletonList(input), CardinalityAggregatorFactory.this.byRow);
            }
        });
    }

    @Override
    public Object deserialize(Object object) {
        ByteBuffer buffer;
        if (object instanceof byte[]) {
            buffer = ByteBuffer.wrap((byte[])object);
        } else if (object instanceof ByteBuffer) {
            buffer = ((ByteBuffer)object).duplicate();
        } else if (object instanceof String) {
            buffer = ByteBuffer.wrap(Base64.decodeBase64((byte[])StringUtils.toUtf8((String)object)));
        } else {
            return object;
        }
        return HyperLogLogCollector.makeCollector(buffer);
    }

    @Override
    public Object finalizeComputation(Object object) {
        return CardinalityAggregatorFactory.estimateCardinality(object);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return CardinalityAggregatorFactory.makeRequiredFieldNamesFromFields(this.fields);
    }

    @JsonProperty
    public List<DimensionSpec> getFields() {
        return this.fields;
    }

    @JsonProperty
    public boolean isByRow() {
        return this.byRow;
    }

    @Override
    public byte[] getCacheKey() {
        ArrayList<byte[]> dimSpecKeys = new ArrayList<byte[]>();
        int dimSpecKeysLength = this.fields.size();
        for (DimensionSpec dimSpec : this.fields) {
            byte[] dimSpecKey = dimSpec.getCacheKey();
            dimSpecKeysLength += dimSpecKey.length;
            dimSpecKeys.add(dimSpec.getCacheKey());
        }
        ByteBuffer retBuf = ByteBuffer.allocate(2 + dimSpecKeysLength);
        retBuf.put((byte)8);
        for (byte[] dimSpecKey : dimSpecKeys) {
            retBuf.put(dimSpecKey);
            retBuf.put((byte)-1);
        }
        retBuf.put((byte)(this.byRow ? 1 : 0));
        return retBuf.array();
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    @Override
    public Object getAggregatorStartValue() {
        return HyperLogLogCollector.makeLatestCollector();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardinalityAggregatorFactory that = (CardinalityAggregatorFactory)o;
        if (this.isByRow() != that.isByRow()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getFields().equals(that.getFields());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getFields().hashCode();
        result = 31 * result + (this.isByRow() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CardinalityAggregatorFactory{name='" + this.name + '\'' + ", fields='" + this.fields + '\'' + '}';
    }
}

