/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;

public class BucketExtractionFn
implements ExtractionFn {
    private final double size;
    private final double offset;

    @JsonCreator
    public BucketExtractionFn(@Nullable @JsonProperty(value="size") Double size, @Nullable @JsonProperty(value="offset") Double offset) {
        this.size = size == null ? 1.0 : size;
        this.offset = offset == null ? 0.0 : offset;
    }

    @JsonProperty
    public double getSize() {
        return this.size;
    }

    @JsonProperty
    public double getOffset() {
        return this.offset;
    }

    @Override
    public String apply(Object value) {
        if (value instanceof Number) {
            return this.bucket((Double)value);
        }
        if (value instanceof String) {
            return this.apply(value);
        }
        return null;
    }

    @Override
    public String apply(String value) {
        try {
            return this.bucket(Double.parseDouble(value));
        }
        catch (NullPointerException | NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public String apply(long value) {
        return this.bucket(value);
    }

    private String bucket(double value) {
        double ret = Math.floor((value - this.offset) / this.size) * this.size + this.offset;
        return ret == (double)((long)ret) ? String.valueOf((long)ret) : String.valueOf(ret);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    @Override
    public byte[] getCacheKey() {
        return ByteBuffer.allocate(17).put((byte)13).putDouble(this.size).putDouble(this.offset).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketExtractionFn that = (BucketExtractionFn)o;
        return this.size == that.size && this.offset == that.offset;
    }
}

