/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;

public class RegexDimExtractionFn
extends DimExtractionFn {
    private static final byte CACHE_KEY_SEPARATOR = -1;
    private final String expr;
    private final Pattern pattern;
    private final boolean replaceMissingValue;
    private final String replaceMissingValueWith;

    @JsonCreator
    public RegexDimExtractionFn(@JsonProperty(value="expr") String expr, @JsonProperty(value="replaceMissingValue") Boolean replaceMissingValue, @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith) {
        Preconditions.checkNotNull(expr, "expr must not be null");
        this.expr = expr;
        this.pattern = Pattern.compile(expr);
        this.replaceMissingValue = replaceMissingValue == null ? false : replaceMissingValue;
        this.replaceMissingValueWith = replaceMissingValueWith;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] byArray;
        byte[] exprBytes = StringUtils.toUtf8(this.expr);
        if (this.replaceMissingValue) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        byte[] replaceBytes = byArray;
        byte[] replaceStrBytes = this.replaceMissingValueWith == null ? new byte[]{} : StringUtils.toUtf8(this.replaceMissingValueWith);
        int totalLen = 1 + exprBytes.length + replaceBytes.length + replaceStrBytes.length;
        return ByteBuffer.allocate(totalLen += 2).put((byte)1).put(exprBytes).put((byte)-1).put(replaceStrBytes).put((byte)-1).put(replaceBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        Matcher matcher = this.pattern.matcher(Strings.nullToEmpty(dimValue));
        String retVal = matcher.find() ? matcher.group(1) : (this.replaceMissingValue ? this.replaceMissingValueWith : dimValue);
        return Strings.emptyToNull(retVal);
    }

    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @JsonProperty(value="replaceMissingValue")
    public boolean isReplaceMissingValue() {
        return this.replaceMissingValue;
    }

    @JsonProperty(value="replaceMissingValueWith")
    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return String.format("regex(%s)", this.expr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexDimExtractionFn that = (RegexDimExtractionFn)o;
        return this.expr.equals(that.expr);
    }

    public int hashCode() {
        return this.expr.hashCode();
    }
}

