/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.segment.filter.JavaScriptFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptDimFilter
implements DimFilter {
    private final String dimension;
    private final String function;
    private final ExtractionFn extractionFn;
    private final JavaScriptConfig config;
    private final JavaScriptPredicateFactory predicateFactory;

    @JsonCreator
    public JavaScriptDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="function") String function, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkArgument(function != null, "function must not be null");
        this.dimension = dimension;
        this.function = function;
        this.extractionFn = extractionFn;
        this.config = config;
        this.predicateFactory = config.isDisabled() ? null : new JavaScriptPredicateFactory(function, extractionFn);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] functionBytes = StringUtils.toUtf8(this.function);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + functionBytes.length + extractionFnBytes.length).put((byte)7).put(dimensionBytes).put((byte)-1).put(functionBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        if (this.config.isDisabled()) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        return new JavaScriptFilter(this.dimension, this.predicateFactory);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public String toString() {
        return "JavaScriptDimFilter{dimension='" + this.dimension + '\'' + ", function='" + this.function + '\'' + ", extractionFn='" + this.extractionFn + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaScriptDimFilter)) {
            return false;
        }
        JavaScriptDimFilter that = (JavaScriptDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.function.equals(that.function)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + this.function.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    public static class JavaScriptPredicateFactory
    implements DruidPredicateFactory {
        final ScriptableObject scope;
        final Function fnApply;
        final String script;
        final ExtractionFn extractionFn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaScriptPredicateFactory(String script, ExtractionFn extractionFn) {
            Preconditions.checkNotNull(script, "script must not be null");
            this.script = script;
            this.extractionFn = extractionFn;
            Context cx = Context.enter();
            try {
                cx.setOptimizationLevel(9);
                this.scope = cx.initStandardObjects();
                this.fnApply = cx.compileFunction((Scriptable)this.scope, script, "script", 1, null);
            }
            finally {
                Context.exit();
            }
        }

        @Override
        public Predicate<String> makeStringPredicate() {
            return new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    return JavaScriptPredicateFactory.this.applyObject(input);
                }
            };
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    return JavaScriptPredicateFactory.this.applyObject(input);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean applyObject(Object input) {
            Context cx = Context.enter();
            try {
                boolean bl = this.applyInContext(cx, input);
                return bl;
            }
            finally {
                Context.exit();
            }
        }

        public boolean applyInContext(Context cx, Object input) {
            if (this.extractionFn != null) {
                input = this.extractionFn.apply(input);
            }
            return Context.toBoolean((Object)this.fnApply.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, new Object[]{input}));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaScriptPredicateFactory that = (JavaScriptPredicateFactory)o;
            return this.script.equals(that.script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }
}

