/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.segment.filter.RegexFilter;

public class RegexDimFilter
implements DimFilter {
    private final String dimension;
    private final String pattern;
    private final ExtractionFn extractionFn;
    private final Pattern compiledPattern;

    @JsonCreator
    public RegexDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="pattern") String pattern, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkArgument(pattern != null, "pattern must not be null");
        this.dimension = dimension;
        this.pattern = pattern;
        this.extractionFn = extractionFn;
        this.compiledPattern = Pattern.compile(pattern);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] patternBytes = StringUtils.toUtf8(this.pattern);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + patternBytes.length + extractionFnBytes.length).put((byte)5).put(dimensionBytes).put((byte)-1).put(patternBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new RegexFilter(this.dimension, this.compiledPattern, this.extractionFn);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public String toString() {
        return "RegexDimFilter{dimension='" + this.dimension + '\'' + ", pattern='" + this.pattern + '\'' + ", extractionFn='" + this.extractionFn + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexDimFilter)) {
            return false;
        }
        RegexDimFilter that = (RegexDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.pattern.equals(that.pattern)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }
}

