/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.segment.filter.DimensionPredicateFilter;
import org.apache.hive.druid.io.druid.segment.filter.SelectorFilter;

public class SelectorDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;
    private final Object initLock = new Object();
    private volatile boolean longsInitialized = false;
    private volatile Long valueAsLong;

    @JsonCreator
    public SelectorDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        this.dimension = dimension;
        this.value = Strings.nullToEmpty(value);
        this.extractionFn = extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] valueBytes = this.value == null ? new byte[]{} : StringUtils.toUtf8(this.value);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + valueBytes.length + extractionFnBytes.length).put((byte)0).put(dimensionBytes).put((byte)-1).put(valueBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return new InDimFilter(this.dimension, ImmutableList.of(this.value), this.extractionFn).optimize();
    }

    @Override
    public Filter toFilter() {
        if (this.extractionFn == null) {
            return new SelectorFilter(this.dimension, this.value);
        }
        final String valueOrNull = Strings.emptyToNull(this.value);
        DruidPredicateFactory predicateFactory = new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return new Predicate<String>(){

                    @Override
                    public boolean apply(String input) {
                        return Objects.equals(valueOrNull, input);
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                SelectorDimFilter.this.initLongValue();
                if (SelectorDimFilter.this.valueAsLong == null) {
                    return new DruidLongPredicate(){

                        @Override
                        public boolean applyLong(long input) {
                            return false;
                        }
                    };
                }
                final long unboxedLong = SelectorDimFilter.this.valueAsLong;
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return input == unboxedLong;
                    }
                };
            }
        };
        return new DimensionPredicateFilter(this.dimension, predicateFactory, this.extractionFn);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public String toString() {
        if (this.extractionFn != null) {
            return String.format("%s(%s) = %s", this.extractionFn, this.dimension, this.value);
        }
        return String.format("%s = %s", this.dimension, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorDimFilter that = (SelectorDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet<String> retSet = TreeRangeSet.create();
        retSet.add(Range.singleton(Strings.nullToEmpty(this.value)));
        return retSet;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLongValue() {
        if (this.longsInitialized) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.longsInitialized) {
                return;
            }
            this.valueAsLong = Longs.tryParse(this.value);
            this.longsInitialized = true;
        }
    }
}

