/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.orderby;

import java.util.Iterator;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;

public class TopNSequence<T>
extends BaseSequence<T, Iterator<T>> {
    public TopNSequence(final Sequence<T> input, final Ordering<T> ordering, final int limit) {
        super(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                if (limit <= 0) {
                    return Iterators.emptyIterator();
                }
                final MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(ordering).maximumSize(limit).create();
                input.accumulate(queue, new Accumulator<MinMaxPriorityQueue<T>, T>(){

                    @Override
                    public MinMaxPriorityQueue<T> accumulate(MinMaxPriorityQueue<T> theQueue, T row) {
                        theQueue.offer(row);
                        return theQueue;
                    }
                });
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return !queue.isEmpty();
                    }

                    @Override
                    public T next() {
                        return queue.poll();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void cleanup(Iterator<T> rowIterator) {
            }
        });
    }
}

