/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeboundary;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.query.BySegmentSkippingQueryRunner;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.DataSourceUtil;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.io.druid.timeline.LogicalSegment;
import org.joda.time.DateTime;
import org.joda.time.ReadableInterval;

public class TimeBoundaryQueryQueryToolChest
extends QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final byte TIMEBOUNDARY_QUERY = 3;
    private static final TypeReference<Result<TimeBoundaryResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeBoundaryResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(TimeBoundaryQuery query, List<T> segments) {
        if (segments.size() <= 1 || query.hasFilters()) {
            return segments;
        }
        final LogicalSegment min = query.isMaxTime() ? null : (LogicalSegment)segments.get(0);
        final LogicalSegment max = query.isMinTime() ? null : (LogicalSegment)segments.get(segments.size() - 1);
        return Lists.newArrayList(Iterables.filter(segments, new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return min != null && input.getInterval().overlaps((ReadableInterval)min.getInterval()) || max != null && input.getInterval().overlaps((ReadableInterval)max.getInterval());
            }
        }));
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeResults(QueryRunner<Result<TimeBoundaryResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<TimeBoundaryResultValue>>(runner){

            @Override
            protected Sequence<Result<TimeBoundaryResultValue>> doRun(QueryRunner<Result<TimeBoundaryResultValue>> baseRunner, Query<Result<TimeBoundaryResultValue>> input, Map<String, Object> context) {
                TimeBoundaryQuery query = (TimeBoundaryQuery)input;
                return Sequences.simple(query.mergeResults(Sequences.toList(baseRunner.run(query, context), Lists.newArrayList())));
            }
        };
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(TimeBoundaryQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query).setDimension("dataSource", DataSourceUtil.getMetricName(query.getDataSource())).setDimension("type", query.getType());
    }

    @Override
    public Function<Result<TimeBoundaryResultValue>, Result<TimeBoundaryResultValue>> makePreComputeManipulatorFn(TimeBoundaryQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<TimeBoundaryResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeBoundaryResultValue>, Object, TimeBoundaryQuery> getCacheStrategy(TimeBoundaryQuery query) {
        return new CacheStrategy<Result<TimeBoundaryResultValue>, Object, TimeBoundaryQuery>(){

            @Override
            public byte[] computeCacheKey(TimeBoundaryQuery query) {
                byte[] cacheKey = query.getCacheKey();
                return ByteBuffer.allocate(1 + cacheKey.length).put((byte)3).put(cacheKey).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeBoundaryResultValue>, Object> prepareForCache() {
                return new Function<Result<TimeBoundaryResultValue>, Object>(){

                    @Override
                    public Object apply(Result<TimeBoundaryResultValue> input) {
                        return Lists.newArrayList(input.getTimestamp().getMillis(), input.getValue());
                    }
                };
            }

            @Override
            public Function<Object, Result<TimeBoundaryResultValue>> pullFromCache() {
                return new Function<Object, Result<TimeBoundaryResultValue>>(){

                    @Override
                    public Result<TimeBoundaryResultValue> apply(Object input) {
                        List result = (List)input;
                        return new Result<TimeBoundaryResultValue>(new DateTime(((Number)result.get(0)).longValue()), new TimeBoundaryResultValue(result.get(1)));
                    }
                };
            }
        };
    }
}

