/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;

public class TopNMapFn
implements Function<Cursor, Result<TopNResultValue>> {
    private final TopNQuery query;
    private final TopNAlgorithm topNAlgorithm;

    public TopNMapFn(TopNQuery query, TopNAlgorithm topNAlgorithm) {
        this.query = query;
        this.topNAlgorithm = topNAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<TopNResultValue> apply(Cursor cursor) {
        DimensionSelector dimSelector = cursor.makeDimensionSelector(this.query.getDimensionSpec());
        if (dimSelector == null) {
            return null;
        }
        TopNParams params = null;
        try {
            params = this.topNAlgorithm.makeInitParams(dimSelector, cursor);
            TopNResultBuilder resultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, this.query);
            this.topNAlgorithm.run(params, resultBuilder, null);
            Result<TopNResultValue> result = resultBuilder.build();
            return result;
        }
        finally {
            this.topNAlgorithm.cleanup(params);
        }
    }
}

