/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;

public class TopNParams {
    private final DimensionSelector dimSelector;
    private final Cursor cursor;
    private final int cardinality;
    private final int numValuesPerPass;

    protected TopNParams(DimensionSelector dimSelector, Cursor cursor, int numValuesPerPass) {
        this.dimSelector = dimSelector;
        this.cursor = cursor;
        this.cardinality = dimSelector.getValueCardinality();
        this.numValuesPerPass = numValuesPerPass;
        if (this.cardinality < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension without a dictionary");
        }
    }

    public DimensionSelector getDimSelector() {
        return this.dimSelector;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getNumValuesPerPass() {
        return this.numValuesPerPass;
    }
}

