/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.CompressedVSizeIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedIntsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedMultivalue;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;

public class CompressedVSizeIndexedV3Supplier
implements WritableSupplier<IndexedMultivalue<IndexedInts>> {
    public static final byte VERSION = 3;
    private final CompressedIntsIndexedSupplier offsetSupplier;
    private final CompressedVSizeIntsIndexedSupplier valueSupplier;

    CompressedVSizeIndexedV3Supplier(CompressedIntsIndexedSupplier offsetSupplier, CompressedVSizeIntsIndexedSupplier valueSupplier) {
        this.offsetSupplier = offsetSupplier;
        this.valueSupplier = valueSupplier;
    }

    public static CompressedVSizeIndexedV3Supplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 3) {
            CompressedIntsIndexedSupplier offsetSupplier = CompressedIntsIndexedSupplier.fromByteBuffer(buffer, order);
            CompressedVSizeIntsIndexedSupplier valueSupplier = CompressedVSizeIntsIndexedSupplier.fromByteBuffer(buffer, order);
            return new CompressedVSizeIndexedV3Supplier(offsetSupplier, valueSupplier);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    public static CompressedVSizeIndexedV3Supplier fromIterable(Iterable<IndexedInts> objectsIterable, int offsetChunkFactor, int maxValue, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        Iterator<IndexedInts> objects = objectsIterable.iterator();
        ArrayList<Integer> offsetList = new ArrayList<Integer>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        int offset = 0;
        while (objects.hasNext()) {
            IndexedInts next = objects.next();
            offsetList.add(offset);
            for (int i = 0; i < next.size(); ++i) {
                values.add(next.get(i));
            }
            offset += next.size();
        }
        offsetList.add(offset);
        CompressedIntsIndexedSupplier headerSupplier = CompressedIntsIndexedSupplier.fromList(offsetList, offsetChunkFactor, byteOrder, compression);
        CompressedVSizeIntsIndexedSupplier valuesSupplier = CompressedVSizeIntsIndexedSupplier.fromList(values, maxValue, CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(maxValue), byteOrder, compression);
        return new CompressedVSizeIndexedV3Supplier(headerSupplier, valuesSupplier);
    }

    @Override
    public long getSerializedSize() {
        return 1L + this.offsetSupplier.getSerializedSize() + this.valueSupplier.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{3}));
        this.offsetSupplier.writeToChannel(channel);
        this.valueSupplier.writeToChannel(channel);
    }

    @Override
    public IndexedMultivalue<IndexedInts> get() {
        return new CompressedVSizeIndexedSupplier.CompressedVSizeIndexed(this.offsetSupplier.get(), this.valueSupplier.get());
    }
}

