/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParseException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.com.google.common.io.Closer;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.com.metamx.common.io.smoosh.Smoosh;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.segment.CompressedVSizeIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.MMappedIndex;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.MetricHolder;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.SegmentUtils;
import org.apache.hive.druid.io.druid.segment.SegmentValidationException;
import org.apache.hive.druid.io.druid.segment.SimpleQueryableIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.ArrayIndexed;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerde;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressedLongsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.io.druid.segment.data.IndexedRTree;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexed;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;
import org.apache.hive.druid.io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.hive.druid.io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.hive.druid.io.druid.segment.serde.FloatGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.FloatGenericColumnSupplier;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnSupplier;
import org.apache.hive.druid.io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import org.joda.time.Interval;

public class IndexIO {
    public static final byte V8_VERSION = 8;
    public static final byte V9_VERSION = 9;
    public static final int CURRENT_VERSION_ID = 9;
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    private final Map<Integer, IndexLoader> indexLoaders;
    private static final EmittingLogger log = new EmittingLogger(IndexIO.class);
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final ObjectMapper mapper;
    private final DefaultIndexIOHandler defaultIndexIOHandler;
    private final ColumnConfig columnConfig;

    @Inject
    public IndexIO(ObjectMapper mapper, ColumnConfig columnConfig) {
        this.mapper = Preconditions.checkNotNull(mapper, "null ObjectMapper");
        this.columnConfig = Preconditions.checkNotNull(columnConfig, "null ColumnConfig");
        this.defaultIndexIOHandler = new DefaultIndexIOHandler(mapper);
        this.indexLoaders = ImmutableMap.builder().put(0, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(1, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(2, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(3, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(4, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(5, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(6, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(7, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(8, new LegacyIndexLoader(this.defaultIndexIOHandler, columnConfig)).put(9, (LegacyIndexLoader)((Object)new V9IndexLoader(columnConfig))).build();
    }

    public void validateTwoSegments(File dir1, File dir2) throws IOException {
        try (QueryableIndex queryableIndex1 = this.loadIndex(dir1);
             QueryableIndex queryableIndex2 = this.loadIndex(dir2);){
            this.validateTwoSegments(new QueryableIndexIndexableAdapter(queryableIndex1), new QueryableIndexIndexableAdapter(queryableIndex2));
        }
    }

    public void validateTwoSegments(IndexableAdapter adapter1, IndexableAdapter adapter2) {
        HashSet<String> metNames2;
        HashSet<String> dimNames2;
        if (adapter1.getNumRows() != adapter2.getNumRows()) {
            throw new SegmentValidationException("Row count mismatch. Expected [%d] found [%d]", adapter1.getNumRows(), adapter2.getNumRows());
        }
        HashSet<String> dimNames1 = Sets.newHashSet(adapter1.getDimensionNames());
        if (!dimNames1.equals(dimNames2 = Sets.newHashSet(adapter2.getDimensionNames()))) {
            throw new SegmentValidationException("Dimension names differ. Expected [%s] found [%s]", dimNames1, dimNames2);
        }
        HashSet<String> metNames1 = Sets.newHashSet(adapter1.getMetricNames());
        if (!metNames1.equals(metNames2 = Sets.newHashSet(adapter2.getMetricNames()))) {
            throw new SegmentValidationException("Metric names differ. Expected [%s] found [%s]", metNames1, metNames2);
        }
        Map<String, DimensionHandler> dimHandlers = adapter1.getDimensionHandlers();
        Iterator<Rowboat> it1 = adapter1.getRows().iterator();
        Iterator<Rowboat> it2 = adapter2.getRows().iterator();
        long row = 0L;
        while (it1.hasNext()) {
            if (!it2.hasNext()) {
                throw new SegmentValidationException("Unexpected end of second adapter", new Object[0]);
            }
            Rowboat rb1 = it1.next();
            Rowboat rb2 = it2.next();
            ++row;
            if (rb1.getRowNum() != rb2.getRowNum()) {
                throw new SegmentValidationException("Row number mismatch: [%d] vs [%d]", rb1.getRowNum(), rb2.getRowNum());
            }
            if (rb1.compareTo(rb2) == 0) continue;
            try {
                IndexIO.validateRowValues(dimHandlers, rb1, adapter1, rb2, adapter2);
            }
            catch (SegmentValidationException ex) {
                throw new SegmentValidationException(ex, "Validation failure on row %d: [%s] vs [%s]", row, rb1, rb2);
            }
        }
        if (it2.hasNext()) {
            throw new SegmentValidationException("Unexpected end of first adapter", new Object[0]);
        }
        if (row != (long)adapter1.getNumRows()) {
            throw new SegmentValidationException("Actual Row count mismatch. Expected [%d] found [%d]", row, adapter1.getNumRows());
        }
    }

    public QueryableIndex loadIndex(File inDir) throws IOException {
        int version = SegmentUtils.getVersionFromDir(inDir);
        IndexLoader loader = this.indexLoaders.get(version);
        if (loader != null) {
            return loader.load(inDir, this.mapper);
        }
        throw new ISE("Unknown index version[%s]", version);
    }

    public static int getVersionFromDir(File inDir) throws IOException {
        int version;
        File versionFile = new File(inDir, "version.bin");
        if (versionFile.exists()) {
            return Ints.fromByteArray(Files.toByteArray(versionFile));
        }
        File indexFile = new File(inDir, "index.drd");
        try (FileInputStream in = new FileInputStream(indexFile);){
            version = ((InputStream)in).read();
        }
        return version;
    }

    public static void checkFileSize(File indexFile) throws IOException {
        long fileSize = indexFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException(String.format("File[%s] too large[%s]", indexFile, fileSize));
        }
    }

    public boolean convertSegment(File toConvert, File converted, IndexSpec indexSpec) throws IOException {
        return this.convertSegment(toConvert, converted, indexSpec, false, true);
    }

    public boolean convertSegment(File toConvert, File converted, IndexSpec indexSpec, boolean forceIfCurrent, boolean validate) throws IOException {
        int version = SegmentUtils.getVersionFromDir(toConvert);
        switch (version) {
            case 1: 
            case 2: 
            case 3: {
                log.makeAlert("Attempt to load segment of version <= 3.", new Object[0]).addData("version", version).emit();
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                log.info("Old version, re-persisting.", new Object[0]);
                try (QueryableIndex segmentToConvert = this.loadIndex(toConvert);){
                    new IndexMerger(this.mapper, this).append(Arrays.asList(new QueryableIndexIndexableAdapter(segmentToConvert)), null, converted, indexSpec);
                }
                return true;
            }
            case 8: {
                this.defaultIndexIOHandler.convertV8toV9(toConvert, converted, indexSpec);
                return true;
            }
        }
        if (forceIfCurrent) {
            new IndexMerger(this.mapper, this).convert(toConvert, converted, indexSpec);
            if (validate) {
                this.validateTwoSegments(toConvert, converted);
            }
            return true;
        }
        log.info("Version[%s], skipping.", version);
        return false;
    }

    public DefaultIndexIOHandler getDefaultIndexIOHandler() {
        return this.defaultIndexIOHandler;
    }

    public static void validateRowValues(Map<String, DimensionHandler> dimHandlers, Rowboat rb1, IndexableAdapter adapter1, Rowboat rb2, IndexableAdapter adapter2) {
        Object[] dims2;
        if (rb1.getTimestamp() != rb2.getTimestamp()) {
            throw new SegmentValidationException("Timestamp mismatch. Expected %d found %d", rb1.getTimestamp(), rb2.getTimestamp());
        }
        Object[] dims1 = rb1.getDims();
        if (dims1.length != (dims2 = rb2.getDims()).length) {
            throw new SegmentValidationException("Dim lengths not equal %s vs %s", Arrays.deepToString(dims1), Arrays.deepToString(dims2));
        }
        Indexed<String> dim1Names = adapter1.getDimensionNames();
        Indexed<String> dim2Names = adapter2.getDimensionNames();
        for (int i = 0; i < dims1.length; ++i) {
            ValueType dim2Type;
            Object dim1Vals = dims1[i];
            Object dim2Vals = dims2[i];
            String dim1Name = dim1Names.get(i);
            String dim2Name = dim2Names.get(i);
            ColumnCapabilities capabilities1 = adapter1.getCapabilities(dim1Name);
            ColumnCapabilities capabilities2 = adapter2.getCapabilities(dim2Name);
            ValueType dim1Type = capabilities1.getType();
            if (dim1Type != (dim2Type = capabilities2.getType())) {
                throw new SegmentValidationException("Dim [%s] types not equal. Expected %d found %d", new Object[]{dim1Name, dim1Type, dim2Type});
            }
            DimensionHandler dimHandler = dimHandlers.get(dim1Name);
            dimHandler.validateSortedEncodedArrays(dim1Vals, dim2Vals, adapter1.getDimValueLookup(dim1Name), adapter2.getDimValueLookup(dim2Name));
        }
    }

    public static File makeDimFile(File dir, String dimension) {
        return new File(dir, String.format("dim_%s.drd", dimension));
    }

    public static File makeNumericDimFile(File dir, String dimension, ByteOrder order) {
        return new File(dir, String.format("numeric_dim_%s_%s.drd", dimension, order));
    }

    public static File makeTimeFile(File dir, ByteOrder order) {
        return new File(dir, String.format("time_%s.drd", order));
    }

    public static File makeMetricFile(File dir, String metricName, ByteOrder order) {
        return new File(dir, String.format("met_%s_%s.drd", metricName, order));
    }

    static class V9IndexLoader
    implements IndexLoader {
        private final ColumnConfig columnConfig;

        V9IndexLoader(ColumnConfig columnConfig) {
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper) throws IOException {
            log.debug("Mapping v9 index[%s]", inDir);
            long startTime = System.currentTimeMillis();
            int theVersion = Ints.fromByteArray(Files.toByteArray(new File(inDir, "version.bin")));
            if (theVersion != 9) {
                throw new IllegalArgumentException(String.format("Expected version[9], got[%s]", theVersion));
            }
            SmooshedFileMapper smooshedFiles = Smoosh.map(inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            GenericIndexed<String> cols = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY);
            GenericIndexed<String> dims = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY);
            Interval dataInterval = new Interval(indexBuffer.getLong(), indexBuffer.getLong());
            BitmapSerdeFactory segmentBitmapSerdeFactory = indexBuffer.hasRemaining() ? mapper.readValue(serializerUtils.readString(indexBuffer), BitmapSerdeFactory.class) : new BitmapSerde.LegacyBitmapSerdeFactory();
            Metadata metadata = null;
            ByteBuffer metadataBB = smooshedFiles.mapFile("metadata.drd");
            if (metadataBB != null) {
                try {
                    metadata = mapper.readValue(serializerUtils.readBytes(metadataBB, metadataBB.remaining()), Metadata.class);
                }
                catch (JsonParseException | JsonMappingException ex) {
                    log.warn(ex, "Failed to load metadata for segment [%s]", inDir);
                }
                catch (IOException ex) {
                    throw new IOException("Failed to read metadata", ex);
                }
            }
            HashMap<String, Column> columns = Maps.newHashMap();
            for (String columnName : cols) {
                columns.put(columnName, this.deserializeColumn(mapper, smooshedFiles.mapFile(columnName)));
            }
            columns.put("__time", this.deserializeColumn(mapper, smooshedFiles.mapFile("__time")));
            SimpleQueryableIndex index = new SimpleQueryableIndex(dataInterval, cols, dims, segmentBitmapSerdeFactory.getBitmapFactory(), columns, smooshedFiles, metadata);
            log.debug("Mapped v9 index[%s] in %,d millis", inDir, System.currentTimeMillis() - startTime);
            return index;
        }

        private Column deserializeColumn(ObjectMapper mapper, ByteBuffer byteBuffer) throws IOException {
            ColumnDescriptor serde = mapper.readValue(serializerUtils.readString(byteBuffer), ColumnDescriptor.class);
            return serde.read(byteBuffer, this.columnConfig);
        }
    }

    static class LegacyIndexLoader
    implements IndexLoader {
        private final IndexIOHandler legacyHandler;
        private final ColumnConfig columnConfig;

        LegacyIndexLoader(IndexIOHandler legacyHandler, ColumnConfig columnConfig) {
            this.legacyHandler = legacyHandler;
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper) throws IOException {
            MMappedIndex index = this.legacyHandler.mapDir(inDir);
            HashMap<String, Column> columns = Maps.newHashMap();
            for (String string : index.getAvailableDimensions()) {
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING).setHasMultipleValues(true).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(index.getDimValueLookup(string), null, Suppliers.ofInstance(index.getDimColumn(string)), this.columnConfig.columnCacheSizeBytes())).setBitmapIndex(new BitmapIndexColumnPartSupplier(new ConciseBitmapFactory(), index.getBitmapIndexes().get(string), index.getDimValueLookup(string)));
                if (index.getSpatialIndexes().get(string) != null) {
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(index.getSpatialIndexes().get(string)));
                }
                columns.put(string, builder.build());
            }
            for (String string : index.getAvailableMetrics()) {
                MetricHolder metricHolder = index.getMetricHolder(string);
                if (metricHolder.getType() == MetricHolder.MetricType.FLOAT) {
                    columns.put(string, new ColumnBuilder().setType(ValueType.FLOAT).setGenericColumn(new FloatGenericColumnSupplier(metricHolder.floatType, BYTE_ORDER)).build());
                    continue;
                }
                if (metricHolder.getType() != MetricHolder.MetricType.COMPLEX) continue;
                columns.put(string, new ColumnBuilder().setType(ValueType.COMPLEX).setComplexColumn(new ComplexColumnPartSupplier(metricHolder.getTypeName(), (GenericIndexed)metricHolder.complexType)).build());
            }
            TreeSet<String> colSet = Sets.newTreeSet();
            for (String dimension : index.getAvailableDimensions()) {
                colSet.add(dimension);
            }
            for (String metric : index.getAvailableMetrics()) {
                colSet.add(metric);
            }
            String[] stringArray = colSet.toArray(new String[colSet.size()]);
            columns.put("__time", new ColumnBuilder().setType(ValueType.LONG).setGenericColumn(new LongGenericColumnSupplier(index.timestamps)).build());
            return new SimpleQueryableIndex(index.getDataInterval(), new ArrayIndexed<String>(stringArray, String.class), index.getAvailableDimensions(), new ConciseBitmapFactory(), columns, index.getFileMapper(), null);
        }
    }

    static interface IndexLoader {
        public QueryableIndex load(File var1, ObjectMapper var2) throws IOException;
    }

    public static class DefaultIndexIOHandler
    implements IndexIOHandler {
        private static final Logger log = new Logger(DefaultIndexIOHandler.class);
        private final ObjectMapper mapper;

        public DefaultIndexIOHandler(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MMappedIndex mapDir(File inDir) throws IOException {
            log.debug("Mapping v8 index[%s]", inDir);
            long startTime = System.currentTimeMillis();
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(inDir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IllegalArgumentException(String.format("Unknown version[%s]", theVersion));
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, false);
                throw throwable;
            }
            Closeables.close(indexIn, false);
            SmooshedFileMapper smooshedFiles = Smoosh.map(inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            indexBuffer.get();
            GenericIndexed<String> availableDimensions = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY);
            GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY);
            Interval dataInterval = new Interval((Object)serializerUtils.readString(indexBuffer));
            BitmapSerde.LegacyBitmapSerdeFactory bitmapSerdeFactory = new BitmapSerde.LegacyBitmapSerdeFactory();
            CompressedLongsIndexedSupplier timestamps = CompressedLongsIndexedSupplier.fromByteBuffer(smooshedFiles.mapFile(IndexIO.makeTimeFile(inDir, BYTE_ORDER).getName()), BYTE_ORDER);
            LinkedHashMap<String, MetricHolder> metrics = Maps.newLinkedHashMap();
            for (String metric : availableMetrics) {
                String metricFilename;
                Object holder;
                if (!metric.equals(((MetricHolder)(holder = MetricHolder.fromByteBuffer(smooshedFiles.mapFile(metricFilename = IndexIO.makeMetricFile(inDir, metric, BYTE_ORDER).getName())))).getName())) {
                    throw new ISE("Metric[%s] loaded up metric[%s] from disk.  File names do matter.", metric, ((MetricHolder)holder).getName());
                }
                metrics.put(metric, (MetricHolder)holder);
            }
            HashMap<String, GenericIndexed<String>> dimValueLookups = Maps.newHashMap();
            HashMap<String, VSizeIndexed> dimColumns = Maps.newHashMap();
            HashMap<String, GenericIndexed<ImmutableBitmap>> bitmaps = Maps.newHashMap();
            for (String dimension : IndexedIterable.create(availableDimensions)) {
                ByteBuffer dimBuffer = smooshedFiles.mapFile(IndexIO.makeDimFile(inDir, dimension).getName());
                String fileDimensionName = serializerUtils.readString(dimBuffer);
                Preconditions.checkState(dimension.equals(fileDimensionName), "Dimension file[%s] has dimension[%s] in it!?", IndexIO.makeDimFile(inDir, dimension), fileDimensionName);
                dimValueLookups.put(dimension, GenericIndexed.read(dimBuffer, GenericIndexed.STRING_STRATEGY));
                dimColumns.put(dimension, VSizeIndexed.readFromByteBuffer(dimBuffer));
            }
            ByteBuffer invertedBuffer = smooshedFiles.mapFile("inverted.drd");
            for (int i = 0; i < availableDimensions.size(); ++i) {
                bitmaps.put(serializerUtils.readString(invertedBuffer), GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
            }
            HashMap<String, ImmutableRTree> spatialIndexed = Maps.newHashMap();
            ByteBuffer spatialBuffer = smooshedFiles.mapFile("spatial.drd");
            while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                spatialIndexed.put(serializerUtils.readString(spatialBuffer), ByteBufferSerializer.read(spatialBuffer, new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory())));
            }
            MMappedIndex retVal = new MMappedIndex(availableDimensions, availableMetrics, dataInterval, timestamps, metrics, dimValueLookups, dimColumns, bitmaps, spatialIndexed, smooshedFiles);
            log.debug("Mapped v8 index[%s] in %,d millis", inDir, System.currentTimeMillis() - startTime);
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void convertV8toV9(File v8Dir, File v9Dir, IndexSpec indexSpec) throws IOException {
            log.info("Converting v8[%s] to v9[%s]", v8Dir, v9Dir);
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(v8Dir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IAE("Unknown version[%s]", theVersion);
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, false);
                throw throwable;
            }
            Closeables.close(indexIn, false);
            try (Closer closer = Closer.create();){
                SmooshedFileMapper v8SmooshedFiles = closer.register(Smoosh.map(v8Dir));
                v9Dir.mkdirs();
                FileSmoosher v9Smoosher = closer.register(new FileSmoosher(v9Dir));
                ByteStreams.write(Ints.toByteArray(9), Files.newOutputStreamSupplier(new File(v9Dir, "version.bin")));
                HashMap<String, GenericIndexed<ImmutableBitmap>> bitmapIndexes = Maps.newHashMap();
                ByteBuffer invertedBuffer = v8SmooshedFiles.mapFile("inverted.drd");
                BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
                while (invertedBuffer.hasRemaining()) {
                    String dimName = serializerUtils.readString(invertedBuffer);
                    bitmapIndexes.put(dimName, GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
                }
                HashMap<String, ImmutableRTree> spatialIndexes = Maps.newHashMap();
                ByteBuffer spatialBuffer = v8SmooshedFiles.mapFile("spatial.drd");
                while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                    spatialIndexes.put(serializerUtils.readString(spatialBuffer), ByteBufferSerializer.read(spatialBuffer, new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory())));
                }
                LinkedHashSet<String> skippedFiles = Sets.newLinkedHashSet();
                final LinkedHashSet<String> skippedDimensions = Sets.newLinkedHashSet();
                for (String filename : v8SmooshedFiles.getInternalFilenames()) {
                    log.info("Processing file[%s]", filename);
                    if (filename.startsWith("dim_")) {
                        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
                        builder.setValueType(ValueType.STRING);
                        ArrayList<ByteBuffer> outParts = Lists.newArrayList();
                        ByteBuffer dimBuffer = v8SmooshedFiles.mapFile(filename);
                        String dimension = serializerUtils.readString(dimBuffer);
                        if (!filename.equals(String.format("dim_%s.drd", dimension))) {
                            throw new ISE("loaded dimension[%s] from file[%s]", dimension, filename);
                        }
                        ByteArrayOutputStream nameBAOS = new ByteArrayOutputStream();
                        serializerUtils.writeString(nameBAOS, dimension);
                        outParts.add(ByteBuffer.wrap(nameBAOS.toByteArray()));
                        GenericIndexed<String> dictionary = GenericIndexed.read(dimBuffer, GenericIndexed.STRING_STRATEGY);
                        if (dictionary.size() == 0) {
                            log.info("Dimension[%s] had cardinality 0, equivalent to no column, so skipping.", dimension);
                            skippedDimensions.add(dimension);
                            continue;
                        }
                        int emptyStrIdx = dictionary.indexOf("");
                        AbstractList<Integer> singleValCol = null;
                        VSizeIndexed multiValCol = VSizeIndexed.readFromByteBuffer(dimBuffer.asReadOnlyBuffer());
                        GenericIndexed<ImmutableBitmap> bitmaps = (GenericIndexed<ImmutableBitmap>)bitmapIndexes.get(dimension);
                        ImmutableRTree spatialIndex = (ImmutableRTree)spatialIndexes.get(dimension);
                        BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
                        boolean onlyOneValue = true;
                        MutableBitmap nullsSet = null;
                        for (int i = 0; i < multiValCol.size(); ++i) {
                            VSizeIndexedInts rowValue = multiValCol.get(i);
                            if (!onlyOneValue) break;
                            if (rowValue.size() > 1) {
                                onlyOneValue = false;
                            }
                            if (rowValue.size() != 0 && rowValue.get(0) != emptyStrIdx) continue;
                            if (nullsSet == null) {
                                nullsSet = bitmapFactory.makeEmptyMutableBitmap();
                            }
                            nullsSet.add(i);
                        }
                        if (onlyOneValue) {
                            boolean bumpedDictionary;
                            log.info("Dimension[%s] is single value, converting...", dimension);
                            if (nullsSet != null) {
                                log.info("Dimension[%s] has null rows.", dimension);
                                ImmutableBitmap theNullSet = bitmapFactory.makeImmutableBitmap(nullsSet);
                                if (dictionary.get(0) != null) {
                                    log.info("Dimension[%s] has no null value in the dictionary, expanding...", dimension);
                                    bumpedDictionary = true;
                                    ArrayList<Object> nullList = Lists.newArrayList();
                                    nullList.add(null);
                                    dictionary = GenericIndexed.fromIterable(Iterables.concat(nullList, dictionary), GenericIndexed.STRING_STRATEGY);
                                    bitmaps = GenericIndexed.fromIterable(Iterables.concat(Arrays.asList(theNullSet), bitmaps), bitmapSerdeFactory.getObjectStrategy());
                                } else {
                                    bumpedDictionary = false;
                                    bitmaps = GenericIndexed.fromIterable(Iterables.concat(Arrays.asList(bitmapFactory.union(Arrays.asList(theNullSet, (ImmutableBitmap)bitmaps.get(0)))), Iterables.skip(bitmaps, 1)), bitmapSerdeFactory.getObjectStrategy());
                                }
                            } else {
                                bumpedDictionary = false;
                            }
                            final VSizeIndexed finalMultiValCol = multiValCol;
                            singleValCol = new AbstractList<Integer>(){

                                @Override
                                public Integer get(int index) {
                                    VSizeIndexedInts ints = finalMultiValCol.get(index);
                                    return ints.size() == 0 ? 0 : ints.get(0) + (bumpedDictionary ? 1 : 0);
                                }

                                @Override
                                public int size() {
                                    return finalMultiValCol.size();
                                }
                            };
                            multiValCol = null;
                        } else {
                            builder.setHasMultipleValues(true);
                        }
                        CompressedObjectStrategy.CompressionStrategy compressionStrategy = indexSpec.getDimensionCompression();
                        DictionaryEncodedColumnPartSerde.LegacySerializerBuilder columnPartBuilder = DictionaryEncodedColumnPartSerde.legacySerializerBuilder().withDictionary(dictionary).withBitmapSerdeFactory(bitmapSerdeFactory).withBitmaps(bitmaps).withSpatialIndex(spatialIndex).withByteOrder(BYTE_ORDER);
                        if (singleValCol != null) {
                            if (compressionStrategy != CompressedObjectStrategy.CompressionStrategy.UNCOMPRESSED) {
                                columnPartBuilder.withSingleValuedColumn(CompressedVSizeIntsIndexedSupplier.fromList((List<Integer>)singleValCol, dictionary.size(), CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(dictionary.size()), BYTE_ORDER, compressionStrategy));
                            } else {
                                columnPartBuilder.withSingleValuedColumn(VSizeIndexedInts.fromList((List<Integer>)singleValCol, dictionary.size()));
                            }
                        } else if (compressionStrategy != CompressedObjectStrategy.CompressionStrategy.UNCOMPRESSED) {
                            columnPartBuilder.withMultiValuedColumn(CompressedVSizeIndexedSupplier.fromIterable(multiValCol, dictionary.size(), BYTE_ORDER, compressionStrategy));
                        } else {
                            columnPartBuilder.withMultiValuedColumn(multiValCol);
                        }
                        ColumnDescriptor serdeficator = builder.addSerde(columnPartBuilder.build()).build();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        serializerUtils.writeString(baos, this.mapper.writeValueAsString(serdeficator));
                        byte[] specBytes = baos.toByteArray();
                        SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(dimension, serdeficator.numBytes() + (long)specBytes.length);
                        channel.write(ByteBuffer.wrap(specBytes));
                        serdeficator.write(channel);
                        channel.close();
                        continue;
                    }
                    if (filename.startsWith("met_") || filename.startsWith("numeric_dim_")) {
                        if (!filename.endsWith(String.format("%s.drd", BYTE_ORDER))) {
                            skippedFiles.add(filename);
                            continue;
                        }
                        MetricHolder holder = MetricHolder.fromByteBuffer(v8SmooshedFiles.mapFile(filename));
                        String metric = holder.getName();
                        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
                        switch (holder.getType()) {
                            case LONG: {
                                builder.setValueType(ValueType.LONG);
                                builder.addSerde(LongGenericColumnPartSerde.legacySerializerBuilder().withByteOrder(BYTE_ORDER).withDelegate(holder.longType).build());
                                break;
                            }
                            case FLOAT: {
                                builder.setValueType(ValueType.FLOAT);
                                builder.addSerde(FloatGenericColumnPartSerde.legacySerializerBuilder().withByteOrder(BYTE_ORDER).withDelegate(holder.floatType).build());
                                break;
                            }
                            case COMPLEX: {
                                if (!(holder.complexType instanceof GenericIndexed)) {
                                    throw new ISE("Serialized complex types must be GenericIndexed objects.", new Object[0]);
                                }
                                GenericIndexed column = (GenericIndexed)holder.complexType;
                                String complexType = holder.getTypeName();
                                builder.setValueType(ValueType.COMPLEX);
                                builder.addSerde(ComplexColumnPartSerde.legacySerializerBuilder().withTypeName(complexType).withDelegate(column).build());
                                break;
                            }
                            default: {
                                throw new ISE("Unknown type[%s]", new Object[]{holder.getType()});
                            }
                        }
                        ColumnDescriptor serdeficator = builder.build();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        serializerUtils.writeString(baos, this.mapper.writeValueAsString(serdeficator));
                        byte[] specBytes = baos.toByteArray();
                        SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(metric, serdeficator.numBytes() + (long)specBytes.length);
                        channel.write(ByteBuffer.wrap(specBytes));
                        serdeficator.write(channel);
                        channel.close();
                        continue;
                    }
                    if (String.format("time_%s.drd", BYTE_ORDER).equals(filename)) {
                        CompressedLongsIndexedSupplier timestamps = CompressedLongsIndexedSupplier.fromByteBuffer(v8SmooshedFiles.mapFile(filename), BYTE_ORDER);
                        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
                        builder.setValueType(ValueType.LONG);
                        builder.addSerde(LongGenericColumnPartSerde.legacySerializerBuilder().withByteOrder(BYTE_ORDER).withDelegate(timestamps).build());
                        ColumnDescriptor serdeficator = builder.build();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        serializerUtils.writeString(baos, this.mapper.writeValueAsString(serdeficator));
                        byte[] specBytes = baos.toByteArray();
                        SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter("__time", serdeficator.numBytes() + (long)specBytes.length);
                        channel.write(ByteBuffer.wrap(specBytes));
                        serdeficator.write(channel);
                        channel.close();
                        continue;
                    }
                    skippedFiles.add(filename);
                }
                ByteBuffer indexBuffer = v8SmooshedFiles.mapFile("index.drd");
                indexBuffer.get();
                GenericIndexed<String> dims8 = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY);
                GenericIndexed<String> dims9 = GenericIndexed.fromIterable(Iterables.filter(dims8, new Predicate<String>(){

                    @Override
                    public boolean apply(String s) {
                        return !skippedDimensions.contains(s);
                    }
                }), GenericIndexed.STRING_STRATEGY);
                GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY);
                Interval dataInterval = new Interval((Object)serializerUtils.readString(indexBuffer));
                BitmapSerdeFactory segmentBitmapSerdeFactory = this.mapper.readValue(serializerUtils.readString(indexBuffer), BitmapSerdeFactory.class);
                TreeSet<String> columns = Sets.newTreeSet();
                columns.addAll(Lists.newArrayList(dims9));
                columns.addAll(Lists.newArrayList(availableMetrics));
                GenericIndexed<String> cols = GenericIndexed.fromIterable(columns, GenericIndexed.STRING_STRATEGY);
                String segmentBitmapSerdeFactoryString = this.mapper.writeValueAsString(segmentBitmapSerdeFactory);
                long numBytes = cols.getSerializedSize() + dims9.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(segmentBitmapSerdeFactoryString);
                SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
                cols.writeToChannel(writer);
                dims9.writeToChannel(writer);
                serializerUtils.writeLong(writer, dataInterval.getStartMillis());
                serializerUtils.writeLong(writer, dataInterval.getEndMillis());
                serializerUtils.writeString(writer, segmentBitmapSerdeFactoryString);
                writer.close();
                ByteBuffer metadataBuffer = v8SmooshedFiles.mapFile("metadata.drd");
                if (metadataBuffer != null) {
                    v9Smoosher.add("metadata.drd", metadataBuffer);
                }
                log.info("Skipped files[%s]", skippedFiles);
            }
        }
    }

    static interface IndexIOHandler {
        public MMappedIndex mapDir(File var1) throws IOException;
    }
}

