/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class NullDimensionSelector
implements DimensionSelector {
    private static final IndexedInts SINGLETON = new IndexedInts(){

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int get(int index) {
            return 0;
        }

        @Override
        public Iterator<Integer> iterator() {
            return Iterators.singletonIterator(0);
        }

        @Override
        public void fill(int index, int[] toFill) {
            throw new UnsupportedOperationException("NullDimensionSelector does not support fill");
        }

        @Override
        public void close() throws IOException {
        }
    };

    @Override
    public IndexedInts getRow() {
        return SINGLETON;
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    public String lookupName(int id) {
        return null;
    }

    @Override
    public int lookupId(String name) {
        return Strings.isNullOrEmpty(name) ? 0 : -1;
    }
}

