/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedFloats;
import org.apache.hive.druid.io.druid.segment.data.VSizeCompressedObjectStrategy;

public class BlockLayoutIndexedFloatSupplier
implements Supplier<IndexedFloats> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseFloatBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutIndexedFloatSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressedObjectStrategy.CompressionStrategy strategy) {
        this.baseFloatBuffers = GenericIndexed.read(fromBuffer, VSizeCompressedObjectStrategy.getBufferForOrder(order, strategy, sizePer * 4));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    @Override
    public IndexedFloats get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            return new BlockLayoutIndexedFloats(){

                @Override
                public float get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.floatBuffer.get(this.floatBuffer.position() + bufferIndex);
                }
            };
        }
        return new BlockLayoutIndexedFloats();
    }

    private class BlockLayoutIndexedFloats
    implements IndexedFloats {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedFloatBuffers;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        FloatBuffer floatBuffer;

        private BlockLayoutIndexedFloats() {
            this.singleThreadedFloatBuffers = BlockLayoutIndexedFloatSupplier.this.baseFloatBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutIndexedFloatSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            int bufferNum = index / BlockLayoutIndexedFloatSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutIndexedFloatSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.floatBuffer.get(this.floatBuffer.position() + bufferIndex);
        }

        @Override
        public void fill(int index, float[] toFill) {
            if (BlockLayoutIndexedFloatSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, BlockLayoutIndexedFloatSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedFloatBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.floatBuffer = this.buffer.asFloatBuffer();
            this.currIndex = bufferNum;
        }

        public String toString() {
            return "BlockCompressedIndexedFloats_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutIndexedFloatSupplier.this.sizePer + ", numChunks=" + this.singleThreadedFloatBuffers.size() + ", totalSize=" + BlockLayoutIndexedFloatSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }
    }
}

