/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.collections.IntList;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIntsIterator;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class IntBufferIndexedInts
implements IndexedInts,
Comparable<IntBufferIndexedInts> {
    public static ObjectStrategy<IntBufferIndexedInts> objectStrategy = new IntBufferIndexedIntsObjectStrategy();
    private final ByteBuffer buffer;

    public static IntBufferIndexedInts fromArray(int[] array) {
        ByteBuffer buffer = ByteBuffer.allocate(array.length * 4);
        buffer.asIntBuffer().put(array);
        return new IntBufferIndexedInts(buffer.asReadOnlyBuffer());
    }

    public static IntBufferIndexedInts fromIntList(IntList intList) {
        ByteBuffer buffer = ByteBuffer.allocate(intList.length() * 4);
        IntBuffer intBuf = buffer.asIntBuffer();
        for (int i = 0; i < intList.length(); ++i) {
            intBuf.put(intList.get(i));
        }
        return new IntBufferIndexedInts(buffer.asReadOnlyBuffer());
    }

    public IntBufferIndexedInts(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int size() {
        return this.buffer.remaining() / 4;
    }

    @Override
    public int get(int index) {
        return this.buffer.getInt(this.buffer.position() + index * 4);
    }

    public ByteBuffer getBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public int compareTo(IntBufferIndexedInts o) {
        return this.buffer.compareTo(o.getBuffer());
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IndexedIntsIterator(this);
    }

    @Override
    public void fill(int index, int[] toFill) {
        throw new UnsupportedOperationException("fill not supported");
    }

    @Override
    public void close() throws IOException {
    }

    private static class IntBufferIndexedIntsObjectStrategy
    implements ObjectStrategy<IntBufferIndexedInts> {
        private IntBufferIndexedIntsObjectStrategy() {
        }

        @Override
        public Class<? extends IntBufferIndexedInts> getClazz() {
            return IntBufferIndexedInts.class;
        }

        @Override
        public IntBufferIndexedInts fromByteBuffer(ByteBuffer buffer, int numBytes) {
            ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
            readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
            return new IntBufferIndexedInts(readOnlyBuffer);
        }

        @Override
        public byte[] toBytes(IntBufferIndexedInts val) {
            ByteBuffer buffer = val.getBuffer();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }

        @Override
        public int compare(IntBufferIndexedInts o1, IntBufferIndexedInts o2) {
            return Ordering.natural().nullsFirst().compare(o1, o2);
        }
    }
}

