/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;

public class LongsLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final ByteBuffer orderBuffer;
    private final ByteOrder order;
    private ByteBuffer outBuffer = null;
    private OutputStream outStream = null;

    public LongsLongEncodingWriter(ByteOrder order) {
        this.order = order;
        this.orderBuffer = ByteBuffer.allocate(8);
        this.orderBuffer.order(order);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.outStream = null;
        this.outBuffer = buffer;
        this.outBuffer.order(this.order);
    }

    @Override
    public void setOutputStream(OutputStream output) {
        this.outBuffer = null;
        this.outStream = output;
    }

    @Override
    public void write(long value) throws IOException {
        if (this.outBuffer != null) {
            this.outBuffer.putLong(value);
        }
        if (this.outStream != null) {
            this.orderBuffer.rewind();
            this.orderBuffer.putLong(value);
            this.outStream.write(this.orderBuffer.array());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void putMeta(OutputStream metaOut, CompressedObjectStrategy.CompressionStrategy strategy) throws IOException {
        metaOut.write(strategy.getId());
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return bytesPerBlock / 8;
    }

    @Override
    public int getNumBytes(int values) {
        return values * 8;
    }
}

