/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.io.File;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorFactory;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderators;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;

public class DefaultAppenderatorFactory
implements AppenderatorFactory {
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final Cache cache;
    private final CacheConfig cacheConfig;

    public DefaultAppenderatorFactory(@JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject @Processing ExecutorService queryExecutorService, @JacksonInject DataSegmentPusher dataSegmentPusher, @JacksonInject ObjectMapper objectMapper, @JacksonInject IndexIO indexIO, @JacksonInject IndexMerger indexMerger, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig) {
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
        this.dataSegmentPusher = dataSegmentPusher;
        this.objectMapper = objectMapper;
        this.indexIO = indexIO;
        this.indexMerger = indexMerger;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
    }

    @Override
    public Appenderator build(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        return Appenderators.createRealtime(schema, config.withBasePersistDirectory(DefaultAppenderatorFactory.makeBasePersistSubdirectory(config.getBasePersistDirectory(), schema.getDataSource(), config.getShardSpec())), metrics, this.dataSegmentPusher, this.objectMapper, this.indexIO, this.indexMerger, this.conglomerate, this.segmentAnnouncer, this.emitter, this.queryExecutorService, this.cache, this.cacheConfig);
    }

    private static File makeBasePersistSubdirectory(File basePersistDirectory, String dataSource, ShardSpec shardSpec) {
        File dataSourceDirectory = new File(basePersistDirectory, dataSource);
        return new File(dataSourceDirectory, String.valueOf(shardSpec.getPartitionNum()));
    }
}

