/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.hive.druid.io.druid.utils.Runnables;
import org.joda.time.DateTime;

public class IngestSegmentFirehose
implements Firehose {
    private volatile Yielder<InputRow> rowYielder;

    public IngestSegmentFirehose(List<WindowedStorageAdapter> adapters, final List<String> dims, final List<String> metrics, final DimFilter dimFilter, final QueryGranularity granularity) {
        Sequence<InputRow> rows = Sequences.concat(Iterables.transform(adapters, new Function<WindowedStorageAdapter, Sequence<InputRow>>(){

            @Override
            @Nullable
            public Sequence<InputRow> apply(WindowedStorageAdapter adapter) {
                return Sequences.concat(Sequences.map(adapter.getAdapter().makeCursors(Filters.toFilter(dimFilter), adapter.getInterval(), granularity, false), new Function<Cursor, Sequence<InputRow>>(){

                    @Override
                    @Nullable
                    public Sequence<InputRow> apply(final Cursor cursor) {
                        final LongColumnSelector timestampColumnSelector = cursor.makeLongColumnSelector("__time");
                        final HashMap<String, DimensionSelector> dimSelectors = Maps.newHashMap();
                        for (String dim : dims) {
                            DimensionSelector dimSelector = cursor.makeDimensionSelector(new DefaultDimensionSpec(dim, dim));
                            if (dimSelector == null) continue;
                            dimSelectors.put(dim, dimSelector);
                        }
                        final HashMap<String, ObjectColumnSelector> metSelectors = Maps.newHashMap();
                        for (String metric : metrics) {
                            ObjectColumnSelector metricSelector = cursor.makeObjectColumnSelector(metric);
                            if (metricSelector == null) continue;
                            metSelectors.put(metric, metricSelector);
                        }
                        return Sequences.simple(new Iterable<InputRow>(){

                            @Override
                            public Iterator<InputRow> iterator() {
                                return new Iterator<InputRow>(){

                                    @Override
                                    public boolean hasNext() {
                                        return !cursor.isDone();
                                    }

                                    @Override
                                    public InputRow next() {
                                        Object selector;
                                        LinkedHashMap<String, Object> theEvent = Maps.newLinkedHashMap();
                                        long timestamp = timestampColumnSelector.get();
                                        theEvent.put("timestamp", new DateTime(timestamp));
                                        for (Map.Entry dimSelector : dimSelectors.entrySet()) {
                                            String dim = (String)dimSelector.getKey();
                                            selector = (DimensionSelector)dimSelector.getValue();
                                            IndexedInts vals = selector.getRow();
                                            if (vals.size() == 1) {
                                                String dimVal = selector.lookupName(vals.get(0));
                                                theEvent.put(dim, dimVal);
                                                continue;
                                            }
                                            ArrayList<String> dimVals = Lists.newArrayList();
                                            for (int i = 0; i < vals.size(); ++i) {
                                                dimVals.add(selector.lookupName(vals.get(i)));
                                            }
                                            theEvent.put(dim, dimVals);
                                        }
                                        for (Map.Entry metSelector : metSelectors.entrySet()) {
                                            String metric = (String)metSelector.getKey();
                                            selector = (ObjectColumnSelector)metSelector.getValue();
                                            theEvent.put(metric, selector.get());
                                        }
                                        cursor.advance();
                                        return new MapBasedInputRow(timestamp, (List<String>)dims, theEvent);
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("Remove Not Supported");
                                    }
                                };
                            }
                        });
                    }
                }));
            }
        }));
        this.rowYielder = rows.toYielder(null, new YieldingAccumulator<InputRow, InputRow>(){

            @Override
            public InputRow accumulate(InputRow accumulated, InputRow in) {
                this.yield();
                return in;
            }
        });
    }

    @Override
    public boolean hasMore() {
        return !this.rowYielder.isDone();
    }

    @Override
    public InputRow nextRow() {
        InputRow inputRow = this.rowYielder.get();
        this.rowYielder = this.rowYielder.next(null);
        return inputRow;
    }

    @Override
    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    @Override
    public void close() throws IOException {
        this.rowYielder.close();
    }
}

