/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.curator.announcement.Announcer;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;

public abstract class AbstractDataSegmentAnnouncer
implements DataSegmentAnnouncer {
    private static final Logger log = new Logger(AbstractDataSegmentAnnouncer.class);
    private final DruidServerMetadata server;
    private final ZkPathsConfig config;
    private final Announcer announcer;
    private final ObjectMapper jsonMapper;
    private final Object lock = new Object();
    private volatile boolean started = false;

    protected AbstractDataSegmentAnnouncer(DruidServerMetadata server, ZkPathsConfig config, Announcer announcer, ObjectMapper jsonMapper) {
        this.server = server;
        this.config = config;
        this.announcer = announcer;
        this.jsonMapper = jsonMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                String path = this.makeAnnouncementPath();
                log.info("Announcing self[%s] at [%s]", this.server, path);
                this.announcer.announce(path, this.jsonMapper.writeValueAsBytes(this.server), false);
            }
            catch (JsonProcessingException e) {
                throw Throwables.propagate(e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Stopping %s with config[%s]", this.getClass(), this.config);
            this.announcer.unannounce(this.makeAnnouncementPath());
            this.started = false;
        }
    }

    private String makeAnnouncementPath() {
        return ZKPaths.makePath((String)this.config.getAnnouncementsPath(), (String)this.server.getName());
    }
}

