/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.rules;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.coordinator.rules.LoadRule;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class PeriodLoadRule
extends LoadRule {
    private static final Logger log = new Logger(PeriodLoadRule.class);
    private final Period period;
    private final Map<String, Integer> tieredReplicants;

    @JsonCreator
    public PeriodLoadRule(@JsonProperty(value="period") Period period, @JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants) {
        this.tieredReplicants = tieredReplicants == null ? ImmutableMap.of("_default_tier", 2) : tieredReplicants;
        this.validateTieredReplicants(this.tieredReplicants);
        this.period = period;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadByPeriod";
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @Override
    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @Override
    public int getNumReplicants(String tier) {
        Integer retVal = this.tieredReplicants.get(tier);
        return retVal == null ? 0 : retVal;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        Interval currInterval = new Interval((ReadablePeriod)this.period, (ReadableInstant)referenceTimestamp);
        return currInterval.overlaps((ReadableInterval)interval) && interval.getStartMillis() >= currInterval.getStartMillis();
    }
}

