/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopFsWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.metamx.common.CompressionUtils;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.common.utils.UUIDUtils;
import org.apache.hive.druid.io.druid.segment.SegmentUtils;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusherUtil;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class HdfsDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(HdfsDataSegmentPusher.class);
    private final HdfsDataSegmentPusherConfig config;
    private final Configuration hadoopConfig;
    private final ObjectMapper jsonMapper;

    @Inject
    public HdfsDataSegmentPusher(HdfsDataSegmentPusherConfig config, Configuration hadoopConfig, ObjectMapper jsonMapper) {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
        this.jsonMapper = jsonMapper;
        log.info("Configured HDFS as deep storage", new Object[0]);
    }

    @Override
    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    @Override
    public String getPathForHadoop() {
        return new Path(this.config.getStorageDirectory()).toUri().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSegment push(File inDir, DataSegment segment) throws IOException {
        DataSegment dataSegment;
        FileSystem fs;
        Path tmpFile;
        block21: {
            String storageDir = DataSegmentPusherUtil.getHdfsStorageDir(segment);
            log.info("Copying segment[%s] to HDFS at location[%s/%s]", segment.getIdentifier(), this.config.getStorageDirectory(), storageDir);
            tmpFile = new Path(String.format("%s/%s/index.zip", this.config.getStorageDirectory(), UUIDUtils.generateUuid(new String[0])));
            fs = tmpFile.getFileSystem(this.hadoopConfig);
            fs.mkdirs(tmpFile.getParent());
            log.info("Compressing files from[%s] to [%s]", inDir, tmpFile);
            try (FSDataOutputStream out = fs.create(tmpFile);){
                long size = CompressionUtils.zip(inDir, (OutputStream)out);
                Path outFile = new Path(String.format("%s/%s/index.zip", this.config.getStorageDirectory(), storageDir));
                Path outDir = outFile.getParent();
                dataSegment = this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(outFile)).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(inDir)), tmpFile.getParent(), fs);
                fs.mkdirs(outDir.getParent());
                if (HadoopFsWrapper.rename(fs, tmpFile.getParent(), outDir)) break block21;
                if (fs.exists(outDir)) {
                    log.info("Unable to rename temp directory[%s] to segment directory[%s]. It is already pushed by a replica task.", tmpFile.getParent(), outDir);
                    break block21;
                }
                throw new IOException(String.format("Failed to rename temp directory[%s] and segment directory[%s] is not present.", tmpFile.getParent(), outDir));
            }
            catch (Throwable throwable) {
                try {
                    if (fs.exists(tmpFile.getParent()) && !fs.delete(tmpFile.getParent(), true)) {
                        log.error("Failed to delete temp directory[%s]", tmpFile.getParent());
                    }
                }
                catch (IOException ex) {
                    log.error(ex, "Failed to delete temp directory[%s]", tmpFile.getParent());
                }
                throw throwable;
            }
        }
        try {
            if (fs.exists(tmpFile.getParent()) && !fs.delete(tmpFile.getParent(), true)) {
                log.error("Failed to delete temp directory[%s]", tmpFile.getParent());
            }
        }
        catch (IOException ex) {
            log.error(ex, "Failed to delete temp directory[%s]", tmpFile.getParent());
        }
        return dataSegment;
    }

    private DataSegment createDescriptorFile(DataSegment segment, Path outDir, FileSystem fs) throws IOException {
        Path descriptorFile = new Path(outDir, "descriptor.json");
        log.info("Creating descriptor file at[%s]", descriptorFile);
        ByteSource.wrap(this.jsonMapper.writeValueAsBytes(segment)).copyTo(new HdfsOutputStreamSupplier(fs, descriptorFile));
        return segment;
    }

    private ImmutableMap<String, Object> makeLoadSpec(Path outFile) {
        return ImmutableMap.of("type", "hdfs", "path", outFile.toUri().toString());
    }

    private static class HdfsOutputStreamSupplier
    extends ByteSink {
        private final FileSystem fs;
        private final Path descriptorFile;

        public HdfsOutputStreamSupplier(FileSystem fs, Path descriptorFile) {
            this.fs = fs;
            this.descriptorFile = descriptorFile;
        }

        @Override
        public OutputStream openStream() throws IOException {
            return this.fs.create(this.descriptorFile);
        }
    }
}

