/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.hive.druid.org.apache.calcite.interpreter.BindableConvention;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class DruidTable
extends AbstractTable
implements TranslatableTable {
    public static final String DEFAULT_TIMESTAMP_COLUMN = "__time";
    public static final Interval DEFAULT_INTERVAL = new Interval((ReadableInstant)new DateTime((Object)"1900-01-01", (Chronology)ISOChronology.getInstanceUTC()), (ReadableInstant)new DateTime((Object)"3000-01-01", (Chronology)ISOChronology.getInstanceUTC()));
    final DruidSchema schema;
    final String dataSource;
    final RelProtoDataType protoRowType;
    final ImmutableSet<String> metricFieldNames;
    final ImmutableList<Interval> intervals;
    final String timestampFieldName;

    public DruidTable(DruidSchema schema, String dataSource, RelProtoDataType protoRowType, Set<String> metricFieldNames, String timestampFieldName, List<Interval> intervals) {
        this.timestampFieldName = Preconditions.checkNotNull(timestampFieldName);
        this.schema = Preconditions.checkNotNull(schema);
        this.dataSource = Preconditions.checkNotNull(dataSource);
        this.protoRowType = protoRowType;
        this.metricFieldNames = ImmutableSet.copyOf(metricFieldNames);
        this.intervals = intervals != null ? ImmutableList.copyOf(intervals) : ImmutableList.of(DEFAULT_INTERVAL);
        for (Interval interval : this.intervals) {
            assert (interval.getChronology() == ISOChronology.getInstanceUTC());
        }
    }

    static Table create(DruidSchema druidSchema, String dataSourceName, List<Interval> intervals, Map<String, SqlTypeName> fieldMap, Set<String> metricNameSet, String timestampColumnName, DruidConnectionImpl connection) {
        if (connection != null) {
            connection.metadata(dataSourceName, timestampColumnName, intervals, fieldMap, metricNameSet);
        }
        ImmutableMap<String, SqlTypeName> fields = ImmutableMap.copyOf(fieldMap);
        return new DruidTable(druidSchema, dataSourceName, new MapRelProtoDataType(fields), ImmutableSet.copyOf(metricNameSet), timestampColumnName, intervals);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType rowType = (RelDataType)this.protoRowType.apply(typeFactory);
        List<String> fieldNames = rowType.getFieldNames();
        Preconditions.checkArgument(fieldNames.contains(this.timestampFieldName));
        Preconditions.checkArgument(fieldNames.containsAll(this.metricFieldNames));
        return rowType;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        LogicalTableScan scan = LogicalTableScan.create(cluster, relOptTable);
        return DruidQuery.create(cluster, cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), relOptTable, this, ImmutableList.of(scan));
    }

    private static class MapRelProtoDataType
    implements RelProtoDataType {
        private final ImmutableMap<String, SqlTypeName> fields;

        MapRelProtoDataType(ImmutableMap<String, SqlTypeName> fields) {
            this.fields = fields;
        }

        @Override
        public RelDataType apply(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map.Entry field : this.fields.entrySet()) {
                builder.add((String)field.getKey(), (SqlTypeName)((Object)field.getValue())).nullable(true);
            }
            return builder.build();
        }
    }
}

