/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.materialize.MaterializationService;
import org.apache.hive.druid.org.apache.calcite.materialize.TileKey;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptMaterialization;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class RelOptLattice {
    public final Lattice lattice;
    public final RelOptTable starRelOptTable;

    public RelOptLattice(Lattice lattice, RelOptTable starRelOptTable) {
        this.lattice = lattice;
        this.starRelOptTable = starRelOptTable;
    }

    public RelOptTable rootTable() {
        return ((Lattice.Node)this.lattice.nodes.get((int)0)).scan.getTable();
    }

    public RelNode rewrite(RelNode node) {
        return RelOptMaterialization.tryUseStar(node, this.starRelOptTable);
    }

    public Pair<CalciteSchema.TableEntry, TileKey> getAggregate(RelOptPlanner planner, ImmutableBitSet groupSet, List<Lattice.Measure> measureList) {
        CalciteConnectionConfig config = planner.getContext().unwrap(CalciteConnectionConfig.class);
        if (config == null) {
            return null;
        }
        MaterializationService service = MaterializationService.instance();
        boolean create = this.lattice.auto && config.createMaterializations();
        CalciteSchema schema = this.starRelOptTable.unwrap(CalciteSchema.class);
        return service.defineTile(this.lattice, groupSet, measureList, schema, create, false);
    }
}

