/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class SqlUpdate
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("UPDATE", SqlKind.UPDATE);
    SqlNode targetTable;
    SqlNodeList targetColumnList;
    SqlNodeList sourceExpressionList;
    SqlNode condition;
    SqlSelect sourceSelect;
    SqlIdentifier alias;

    public SqlUpdate(SqlParserPos pos, SqlNode targetTable, SqlNodeList targetColumnList, SqlNodeList sourceExpressionList, SqlNode condition, SqlSelect sourceSelect, SqlIdentifier alias) {
        super(pos);
        this.targetTable = targetTable;
        this.targetColumnList = targetColumnList;
        this.sourceExpressionList = sourceExpressionList;
        this.condition = condition;
        this.sourceSelect = sourceSelect;
        assert (sourceExpressionList.size() == targetColumnList.size());
        this.alias = alias;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.UPDATE;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.targetTable, this.targetColumnList, this.sourceExpressionList, this.condition, this.alias);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                assert (operand instanceof SqlIdentifier);
                this.targetTable = operand;
                break;
            }
            case 1: {
                this.targetColumnList = (SqlNodeList)operand;
                break;
            }
            case 2: {
                this.sourceExpressionList = (SqlNodeList)operand;
                break;
            }
            case 3: {
                this.condition = operand;
                break;
            }
            case 4: {
                this.sourceExpressionList = (SqlNodeList)operand;
                break;
            }
            case 5: {
                this.alias = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTargetTable() {
        return this.targetTable;
    }

    public SqlIdentifier getAlias() {
        return this.alias;
    }

    public void setAlias(SqlIdentifier alias) {
        this.alias = alias;
    }

    public SqlNodeList getTargetColumnList() {
        return this.targetColumnList;
    }

    public SqlNodeList getSourceExpressionList() {
        return this.sourceExpressionList;
    }

    public SqlNode getCondition() {
        return this.condition;
    }

    public SqlSelect getSourceSelect() {
        return this.sourceSelect;
    }

    public void setSourceSelect(SqlSelect sourceSelect) {
        this.sourceSelect = sourceSelect;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SELECT, "UPDATE", "");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.alias != null) {
            writer.keyword("AS");
            this.alias.unparse(writer, opLeft, opRight);
        }
        SqlWriter.Frame setFrame = writer.startList(SqlWriter.FrameTypeEnum.UPDATE_SET_LIST, "SET", "");
        for (Pair<SqlNode, SqlNode> pair : Pair.zip(this.getTargetColumnList(), this.getSourceExpressionList())) {
            writer.sep(",");
            SqlIdentifier id = (SqlIdentifier)pair.left;
            id.unparse(writer, opLeft, opRight);
            writer.keyword("=");
            SqlNode sourceExp = (SqlNode)pair.right;
            sourceExp.unparse(writer, opLeft, opRight);
        }
        writer.endList(setFrame);
        if (this.condition != null) {
            writer.sep("WHERE");
            this.condition.unparse(writer, opLeft, opRight);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateUpdate(this);
    }
}

