/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.StructKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWindow;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlQualified;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public interface SqlValidatorScope {
    public SqlValidator getValidator();

    public SqlNode getNode();

    public void resolve(List<String> var1, boolean var2, Resolved var3);

    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String var1, SqlNode var2);

    public void findAllColumnNames(List<SqlMoniker> var1);

    public void findAliases(Collection<SqlMoniker> var1);

    public SqlQualified fullyQualify(SqlIdentifier var1);

    public void addChild(SqlValidatorNamespace var1, String var2);

    public SqlWindow lookupWindow(String var1);

    public SqlMonotonicity getMonotonicity(SqlNode var1);

    public SqlNodeList getOrderList();

    public RelDataType resolveColumn(String var1, SqlNode var2);

    public SqlValidatorScope getOperandScope(SqlCall var1);

    public void validateExpr(SqlNode var1);

    public SqlValidatorNamespace getTableNamespace(List<String> var1);

    public RelDataType nullifyType(SqlNode var1, RelDataType var2);

    public static class Resolve {
        public final SqlValidatorNamespace namespace;
        public final SqlValidatorScope scope;
        public final Path path;

        Resolve(SqlValidatorNamespace namespace, SqlValidatorScope scope, Path path) {
            this.namespace = Preconditions.checkNotNull(namespace);
            this.scope = scope;
            this.path = path;
        }
    }

    public static class ResolvedImpl
    implements Resolved {
        final List<Resolve> resolves = new ArrayList<Resolve>();
        private final EmptyPath emptyPath = new EmptyPath();

        @Override
        public void found(SqlValidatorNamespace namespace, SqlValidatorScope scope, Path path) {
            this.resolves.add(new Resolve(namespace, scope, path));
        }

        @Override
        public int count() {
            return this.resolves.size();
        }

        @Override
        public Path emptyPath() {
            return this.emptyPath;
        }

        public Resolve only() {
            return Iterables.getOnlyElement(this.resolves);
        }

        public void clear() {
            this.resolves.clear();
        }
    }

    public static class Step
    extends Path {
        final Path parent;
        final RelDataType rowType;
        public final int i;
        final StructKind kind;

        Step(Path parent, RelDataType rowType, int i, StructKind kind) {
            this.parent = Preconditions.checkNotNull(parent);
            this.rowType = rowType;
            this.i = i;
            this.kind = Preconditions.checkNotNull(kind);
        }

        @Override
        public int stepCount() {
            return 1 + this.parent.stepCount();
        }

        @Override
        protected void build(ImmutableList.Builder<Step> paths) {
            this.parent.build(paths);
            paths.add((Object)this);
        }
    }

    public static class EmptyPath
    extends Path {
    }

    public static abstract class Path {
        Step add(RelDataType rowType, int i, StructKind kind) {
            return new Step(this, rowType, i, kind);
        }

        public int stepCount() {
            return 0;
        }

        public List<Step> steps() {
            ImmutableList.Builder<Step> paths = new ImmutableList.Builder<Step>();
            this.build(paths);
            return paths.build();
        }

        protected void build(ImmutableList.Builder<Step> paths) {
        }
    }

    public static interface Resolved {
        public void found(SqlValidatorNamespace var1, SqlValidatorScope var2, Path var3);

        public int count();

        public Path emptyPath();
    }
}

