/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;

public class TaskReportData {
    private final String id;
    private final Map<Integer, Long> startingOffsets;
    private final DateTime startTime;
    private final Long remainingSeconds;
    private final TaskType type;
    private final Map<Integer, Long> currentOffsets;
    private final Map<Integer, Long> lag;

    public TaskReportData(String id, @Nullable Map<Integer, Long> startingOffsets, @Nullable Map<Integer, Long> currentOffsets, DateTime startTime, Long remainingSeconds, TaskType type, @Nullable Map<Integer, Long> lag) {
        this.id = id;
        this.startingOffsets = startingOffsets;
        this.currentOffsets = currentOffsets;
        this.startTime = startTime;
        this.remainingSeconds = remainingSeconds;
        this.type = type;
        this.lag = lag;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<Integer, Long> getStartingOffsets() {
        return this.startingOffsets;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<Integer, Long> getCurrentOffsets() {
        return this.currentOffsets;
    }

    @JsonProperty
    public DateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Long getRemainingSeconds() {
        return this.remainingSeconds;
    }

    @JsonProperty
    public TaskType getType() {
        return this.type;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<Integer, Long> getLag() {
        return this.lag;
    }

    public String toString() {
        return "{id='" + this.id + '\'' + (this.startingOffsets != null ? ", startingOffsets=" + this.startingOffsets : "") + (this.currentOffsets != null ? ", currentOffsets=" + this.currentOffsets : "") + ", startTime=" + this.startTime + ", remainingSeconds=" + this.remainingSeconds + (this.lag != null ? ", lag=" + this.lag : "") + '}';
    }

    public static enum TaskType {
        ACTIVE,
        PUBLISHING,
        UNKNOWN;

    }
}

