/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidSerDeUtils;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"druid.datasource"})
public class DruidSerDe
extends AbstractSerDe {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidSerDe.class);
    private String[] columns;
    private PrimitiveTypeInfo[] types;
    private ObjectInspector inspector;
    private TimestampLocalTZTypeInfo tsTZTypeInfo;

    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        this.tsTZTypeInfo = new TimestampLocalTZTypeInfo(configuration.get(HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE.varname));
        String druidQuery = properties.getProperty("druid.query.json", null);
        if (druidQuery != null && !druidQuery.isEmpty()) {
            this.initFromDruidQueryPlan(properties, druidQuery);
        } else if (!org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns")) && !org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns.types"))) {
            this.initFromProperties(properties);
        } else {
            this.initFromMetaDataQuery(configuration, properties);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DruidSerDe initialized with\n\t columns: " + Arrays.toString(this.columns) + "\n\t types: " + Arrays.toString(this.types));
        }
    }

    private void initFromMetaDataQuery(Configuration configuration, Properties properties) throws SerDeException {
        SegmentAnalysis schemaInfo;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TimestampLocalTZTypeInfo> columnTypes = new ArrayList<TimestampLocalTZTypeInfo>();
        ArrayList<AbstractPrimitiveWritableObjectInspector> inspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>();
        String dataSource = properties.getProperty("druid.datasource");
        if (dataSource == null) {
            throw new SerDeException("Druid data source not specified; use druid.datasource in table properties");
        }
        Druids.SegmentMetadataQueryBuilder builder = new Druids.SegmentMetadataQueryBuilder();
        builder.dataSource(dataSource);
        builder.merge(true);
        builder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
        SegmentMetadataQuery query = builder.build();
        String address = HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
        if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
            throw new SerDeException("Druid broker address not specified in configuration");
        }
        try {
            schemaInfo = this.submitMetadataRequest(address, query);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        for (Map.Entry<String, ColumnAnalysis> columnInfo : schemaInfo.getColumns().entrySet()) {
            TimestampLocalTZTypeInfo type;
            if (columnInfo.getKey().equals("__time")) {
                columnNames.add(columnInfo.getKey());
                type = this.tsTZTypeInfo;
                columnTypes.add(type);
                inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type));
                continue;
            }
            columnNames.add(columnInfo.getKey());
            type = DruidSerDeUtils.convertDruidToHiveType(columnInfo.getValue().getType());
            columnTypes.add(type instanceof TimestampLocalTZTypeInfo ? this.tsTZTypeInfo : type);
            inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type));
        }
        this.columns = columnNames.toArray(new String[columnNames.size()]);
        this.types = columnTypes.toArray(new PrimitiveTypeInfo[columnTypes.size()]);
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    private void initFromProperties(Properties properties) throws SerDeException {
        ArrayList inspectors = new ArrayList();
        ArrayList columnNames = new ArrayList();
        ArrayList columnTypes = new ArrayList();
        columnNames.addAll(Utilities.getColumnNames((Properties)properties));
        if (!columnNames.contains("__time")) {
            throw new SerDeException("Timestamp column (' __time') not specified in create table; list of columns is : " + properties.getProperty("columns"));
        }
        columnTypes.addAll(Lists.transform(Lists.transform(Utilities.getColumnTypes((Properties)properties), type -> TypeInfoFactory.getPrimitiveTypeInfo((String)type)), e -> e instanceof TimestampLocalTZTypeInfo ? this.tsTZTypeInfo : e));
        inspectors.addAll(Lists.transform(columnTypes, type -> PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type)));
        this.columns = columnNames.toArray(new String[columnNames.size()]);
        this.types = columnTypes.toArray(new PrimitiveTypeInfo[columnTypes.size()]);
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    private void initFromDruidQueryPlan(Properties properties, String druidQuery) {
        List columnTypes;
        List columnNames;
        Preconditions.checkNotNull(druidQuery, "Why Druid query is null");
        ArrayList<AbstractPrimitiveWritableObjectInspector> inspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>();
        String fieldNamesProperty = Preconditions.checkNotNull(properties.getProperty("druid.fieldNames", null));
        String fieldTypesProperty = Preconditions.checkNotNull(properties.getProperty("druid.fieldTypes", null));
        if (fieldNamesProperty.isEmpty()) {
            columnNames = Collections.EMPTY_LIST;
            columnTypes = Collections.EMPTY_LIST;
        } else {
            columnNames = Arrays.stream(fieldNamesProperty.trim().split(",")).collect(Collectors.toList());
            columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)fieldTypesProperty).stream().map(e -> TypeInfoFactory.getPrimitiveTypeInfo((String)e.getTypeName())).map(primitiveTypeInfo -> {
                if (primitiveTypeInfo instanceof TimestampLocalTZTypeInfo) {
                    return this.tsTZTypeInfo;
                }
                return primitiveTypeInfo;
            }).collect(Collectors.toList());
        }
        this.columns = new String[columnNames.size()];
        this.types = new PrimitiveTypeInfo[columnNames.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            this.columns[i] = (String)columnNames.get(i);
            this.types[i] = (PrimitiveTypeInfo)columnTypes.get(i);
            inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.types[i]));
        }
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    protected SegmentAnalysis submitMetadataRequest(String address, SegmentMetadataQuery query) throws SerDeException, IOException {
        List resultsList;
        InputStream response;
        try {
            response = DruidStorageHandlerUtils.submitRequest(DruidStorageHandler.getHttpClient(), DruidStorageHandlerUtils.createSmileRequest(address, query));
        }
        catch (Exception e) {
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            resultsList = (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(response, (TypeReference)new TypeReference<List<SegmentAnalysis>>(){});
        }
        catch (Exception e) {
            response.close();
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        if (resultsList == null || resultsList.isEmpty()) {
            throw new SerDeException("Connected to Druid but could not retrieve datasource information");
        }
        if (resultsList.size() != 1) {
            throw new SerDeException("Information about segments should have been merged");
        }
        return (SegmentAnalysis)resultsList.get(0);
    }

    public Class<? extends Writable> getSerializedClass() {
        return DruidWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (objectInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objectInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        List fields = soi.getAllStructFieldRefs();
        List values = soi.getStructFieldsDataAsList(o);
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.length; ++i) {
            Object res;
            if (values.get(i) == null) {
                value.put(this.columns[i], null);
                continue;
            }
            switch (this.types[i].getPrimitiveCategory()) {
                case TIMESTAMP: {
                    res = ((TimestampObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).toEpochMilli();
                    break;
                }
                case TIMESTAMPLOCALTZ: {
                    res = ((TimestampLocalTZObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getZonedDateTime().toInstant().toEpochMilli();
                    break;
                }
                case BYTE: {
                    res = ((ByteObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case SHORT: {
                    res = ((ShortObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case INT: {
                    res = ((IntObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case LONG: {
                    res = ((LongObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case FLOAT: {
                    res = Float.valueOf(((FloatObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i)));
                    break;
                }
                case DOUBLE: {
                    res = ((DoubleObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case CHAR: {
                    res = ((HiveCharObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getValue();
                    break;
                }
                case VARCHAR: {
                    res = ((HiveVarcharObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getValue();
                    break;
                }
                case STRING: {
                    res = ((StringObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i));
                    break;
                }
                case BOOLEAN: {
                    res = ((BooleanObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                default: {
                    throw new SerDeException("Unsupported type: " + this.types[i].getPrimitiveCategory());
                }
            }
            value.put(this.columns[i], res);
        }
        int granularityFieldIndex = this.columns.length;
        assert (values.size() > granularityFieldIndex);
        Preconditions.checkArgument(((StructField)fields.get(granularityFieldIndex)).getFieldName().equals("__time_granularity"));
        value.put("__time_granularity", ((TimestampObjectInspector)((StructField)fields.get(granularityFieldIndex)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(granularityFieldIndex)).toEpochMilli());
        if (values.size() == this.columns.length + 2) {
            int partitionNumPos = granularityFieldIndex + 1;
            Preconditions.checkArgument(((StructField)fields.get(partitionNumPos)).getFieldName().equals("__druid_extra_partition_key"), String.format("expecting to encounter %s but was %s", "__druid_extra_partition_key", ((StructField)fields.get(partitionNumPos)).getFieldName()));
            value.put("__druid_extra_partition_key", ((LongObjectInspector)((StructField)fields.get(partitionNumPos)).getFieldObjectInspector()).get(values.get(partitionNumPos)));
        }
        return new DruidWritable(value);
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        DruidWritable input = (DruidWritable)writable;
        ArrayList<Object> output = Lists.newArrayListWithExpectedSize(this.columns.length);
        block15: for (int i = 0; i < this.columns.length; ++i) {
            Object value = input.getValue().get(this.columns[i]);
            if (value == null) {
                output.add(null);
                continue;
            }
            switch (this.types[i].getPrimitiveCategory()) {
                case TIMESTAMP: {
                    if (value instanceof Number) {
                        output.add(new TimestampWritableV2(Timestamp.valueOf((String)ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), this.tsTZTypeInfo.timeZone()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))));
                        continue block15;
                    }
                    output.add(new TimestampWritableV2(Timestamp.valueOf((String)((String)value))));
                    continue block15;
                }
                case TIMESTAMPLOCALTZ: {
                    long numberOfMillis = value instanceof Number ? ((Number)value).longValue() : ISODateTimeFormat.dateOptionalTimeParser().parseDateTime((String)value).getMillis();
                    output.add(new TimestampLocalTZWritable(new TimestampTZ(ZonedDateTime.ofInstant(Instant.ofEpochMilli(numberOfMillis), ((TimestampLocalTZTypeInfo)this.types[i]).timeZone()))));
                    continue block15;
                }
                case DATE: {
                    DateWritableV2 dateWritable = value instanceof Number ? new DateWritableV2(Date.ofEpochMilli((long)((Number)value).longValue())) : new DateWritableV2(Date.ofEpochMilli((long)ISODateTimeFormat.dateOptionalTimeParser().parseDateTime((String)value).getMillis()));
                    output.add(dateWritable);
                    continue block15;
                }
                case BYTE: {
                    output.add(new ByteWritable(((Number)value).byteValue()));
                    continue block15;
                }
                case SHORT: {
                    output.add(new ShortWritable(((Number)value).shortValue()));
                    continue block15;
                }
                case INT: {
                    if (value instanceof Number) {
                        output.add(new IntWritable(((Number)value).intValue()));
                        continue block15;
                    }
                    output.add(new IntWritable(Integer.valueOf((String)value).intValue()));
                    continue block15;
                }
                case LONG: {
                    output.add(new LongWritable(((Number)value).longValue()));
                    continue block15;
                }
                case FLOAT: {
                    output.add(new FloatWritable(((Number)value).floatValue()));
                    continue block15;
                }
                case DOUBLE: {
                    output.add(new DoubleWritable(((Number)value).doubleValue()));
                    continue block15;
                }
                case CHAR: {
                    output.add(new HiveCharWritable(new HiveChar(value.toString(), ((CharTypeInfo)this.types[i]).getLength())));
                    continue block15;
                }
                case VARCHAR: {
                    output.add(new HiveVarcharWritable(new HiveVarchar(value.toString(), ((VarcharTypeInfo)this.types[i]).getLength())));
                    continue block15;
                }
                case STRING: {
                    output.add(new Text(value.toString()));
                    continue block15;
                }
                case BOOLEAN: {
                    if (value instanceof Number) {
                        output.add(new BooleanWritable(((Number)value).intValue() != 0));
                        continue block15;
                    }
                    output.add(new BooleanWritable(Boolean.valueOf(value.toString()).booleanValue()));
                    continue block15;
                }
                default: {
                    throw new SerDeException("Unknown type: " + this.types[i].getPrimitiveCategory());
                }
            }
        }
        return output;
    }

    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    public boolean shouldStoreFieldsInMetastore(Map<String, String> tableParams) {
        return !MetaStoreUtils.isExternal(tableParams);
    }
}

