/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Multimap;

public class MultimapSerializer
extends ContainerSerializer<Multimap<?, ?>>
implements ContextualSerializer {
    private final MapLikeType _type;
    private final BeanProperty _property;
    private final JsonSerializer<Object> _keySerializer;
    private final TypeSerializer _valueTypeSerializer;
    private final JsonSerializer<Object> _valueSerializer;

    public MultimapSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer valueTypeSerializer, JsonSerializer<Object> valueSerializer) {
        super(type.getRawClass(), false);
        this._type = type;
        this._property = null;
        this._keySerializer = keySerializer;
        this._valueTypeSerializer = valueTypeSerializer;
        this._valueSerializer = valueSerializer;
    }

    protected MultimapSerializer(MultimapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, TypeSerializer valueTypeSerializer, JsonSerializer<?> valueSerializer) {
        super(src);
        this._type = src._type;
        this._property = property;
        this._keySerializer = keySerializer;
        this._valueTypeSerializer = valueTypeSerializer;
        this._valueSerializer = valueSerializer;
    }

    protected MultimapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySer, TypeSerializer vts, JsonSerializer<?> valueSer) {
        return new MultimapSerializer(this, property, keySer, vts, valueSer);
    }

    @Override
    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSer) {
        return new MultimapSerializer(this, this._property, this._keySerializer, typeSer, this._valueSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> valueSer = this._valueSerializer;
        if (valueSer == null) {
            JavaType valueType = this._type.getContentType();
            if (valueType.isFinal()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else if (valueSer instanceof ContextualSerializer) {
            valueSer = ((ContextualSerializer)((Object)valueSer)).createContextual(provider, property);
        }
        JsonSerializer<Object> keySer = this._keySerializer;
        if (keySer == null) {
            keySer = provider.findKeySerializer(this._type.getKeyType(), property);
        } else if (keySer instanceof ContextualSerializer) {
            keySer = ((ContextualSerializer)((Object)keySer)).createContextual(provider, property);
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        return this.withResolved(property, keySer, typeSer, valueSer);
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public JavaType getContentType() {
        return this._type.getContentType();
    }

    @Override
    public boolean hasSingleElement(Multimap<?, ?> map) {
        return map.size() == 1;
    }

    @Override
    public boolean isEmpty(Multimap<?, ?> map) {
        return map.isEmpty();
    }

    @Override
    public void serialize(Multimap<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        if (!value.isEmpty()) {
            this.serializeFields(value, gen, provider);
        }
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Multimap<?, ?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value, gen);
        this.serializeFields(value, gen, provider);
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    private final void serializeFields(Multimap<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
        for (Map.Entry<?, Collection<?>> e : value.asMap().entrySet()) {
            if (this._keySerializer != null) {
                this._keySerializer.serialize(e.getKey(), gen, provider);
            } else {
                provider.findKeySerializer(provider.constructType((Type)((Object)String.class)), this._property).serialize(e.getKey(), gen, provider);
            }
            if (this._valueSerializer != null) {
                gen.writeStartArray();
                for (Object vv : e.getValue()) {
                    if (vv == null) {
                        provider.defaultSerializeNull(gen);
                        continue;
                    }
                    this._valueSerializer.serialize(vv, gen, provider);
                }
                gen.writeEndArray();
                continue;
            }
            provider.defaultSerializeValue(Lists.newArrayList((Iterable)e.getValue()), gen);
        }
    }
}

