/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.http.client;

import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.joda.time.Duration;

public class HttpClientConfig {
    public static final CompressionCodec DEFAULT_COMPRESSION_CODEC = CompressionCodec.GZIP;
    private static final int DEFAULT_BOSS_COUNT = 1;
    private static final int DEFAULT_WORKER_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private final int numConnections;
    private final SSLContext sslContext;
    private final Duration readTimeout;
    private final Duration sslHandshakeTimeout;
    private final int bossPoolSize;
    private final int workerPoolSize;
    private final CompressionCodec compressionCodec;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public HttpClientConfig(int numConnections, SSLContext sslContext) {
        this(numConnections, sslContext, Duration.ZERO, null, 1, DEFAULT_WORKER_COUNT, DEFAULT_COMPRESSION_CODEC);
    }

    @Deprecated
    public HttpClientConfig(int numConnections, SSLContext sslContext, Duration readTimeout) {
        this(numConnections, sslContext, readTimeout, null, 1, DEFAULT_WORKER_COUNT, DEFAULT_COMPRESSION_CODEC);
    }

    @Deprecated
    public HttpClientConfig(int numConnections, SSLContext sslContext, Duration readTimeout, Duration sslHandshakeTimeout) {
        this(numConnections, sslContext, readTimeout, sslHandshakeTimeout, 1, DEFAULT_WORKER_COUNT, DEFAULT_COMPRESSION_CODEC);
    }

    private HttpClientConfig(int numConnections, SSLContext sslContext, Duration readTimeout, Duration sslHandshakeTimeout, int bossPoolSize, int workerPoolSize, CompressionCodec compressionCodec) {
        this.numConnections = numConnections;
        this.sslContext = sslContext;
        this.readTimeout = readTimeout;
        this.sslHandshakeTimeout = sslHandshakeTimeout;
        this.bossPoolSize = bossPoolSize;
        this.workerPoolSize = workerPoolSize;
        this.compressionCodec = compressionCodec;
    }

    public int getNumConnections() {
        return this.numConnections;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public int getBossPoolSize() {
        return this.bossPoolSize;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    static /* synthetic */ int access$200() {
        return DEFAULT_WORKER_COUNT;
    }

    public static class Builder {
        private int numConnections = 1;
        private SSLContext sslContext = null;
        private Duration readTimeout = null;
        private Duration sslHandshakeTimeout = null;
        private int bossCount = 1;
        private int workerCount = HttpClientConfig.access$200();
        private CompressionCodec compressionCodec = DEFAULT_COMPRESSION_CODEC;

        private Builder() {
        }

        public Builder withNumConnections(int numConnections) {
            this.numConnections = numConnections;
            return this;
        }

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withSslContext(String keyStorePath, String keyStorePassword) {
            this.sslContext = HttpClientInit.sslContextWithTrustedKeyStore(keyStorePath, keyStorePassword);
            return this;
        }

        public Builder withReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withSslHandshakeTimeout(Duration sslHandshakeTimeout) {
            this.sslHandshakeTimeout = sslHandshakeTimeout;
            return this;
        }

        public Builder withBossCount(int bossCount) {
            this.bossCount = bossCount;
            return this;
        }

        public Builder withWorkerCount(int workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        public Builder withCompressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.numConnections, this.sslContext, this.readTimeout, this.sslHandshakeTimeout, this.bossCount, this.workerCount, this.compressionCodec);
        }
    }

    public static enum CompressionCodec {
        IDENTITY{

            @Override
            public String getEncodingString() {
                return "identity";
            }
        }
        ,
        GZIP{

            @Override
            public String getEncodingString() {
                return "gzip";
            }
        }
        ,
        DEFLATE{

            @Override
            public String getEncodingString() {
                return "deflate";
            }
        };


        public abstract String getEncodingString();
    }
}

