/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.http.client.response;

import java.nio.charset.Charset;
import org.apache.hive.druid.com.metamx.http.client.response.ClientResponse;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.com.metamx.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;

public class StatusResponseHandler
implements HttpResponseHandler<StatusResponseHolder, StatusResponseHolder> {
    private final Charset charset;

    public StatusResponseHandler(Charset charset) {
        this.charset = charset;
    }

    @Override
    public ClientResponse<StatusResponseHolder> handleResponse(HttpResponse response) {
        return ClientResponse.unfinished(new StatusResponseHolder(response.getStatus(), new StringBuilder(response.getContent().toString(this.charset))));
    }

    @Override
    public ClientResponse<StatusResponseHolder> handleChunk(ClientResponse<StatusResponseHolder> response, HttpChunk chunk) {
        StringBuilder builder = response.getObj().getBuilder();
        if (builder == null) {
            return ClientResponse.finished(null);
        }
        builder.append(chunk.getContent().toString(this.charset));
        return response;
    }

    @Override
    public ClientResponse<StatusResponseHolder> done(ClientResponse<StatusResponseHolder> response) {
        return ClientResponse.finished(response.getObj());
    }

    @Override
    public void exceptionCaught(ClientResponse<StatusResponseHolder> clientResponse, Throwable e) {
    }
}

