/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.bitmap;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.MutableRoaringBitmap;

public class WrappedRoaringBitmap
implements MutableBitmap {
    private final boolean compressRunOnSerialization;
    private MutableRoaringBitmap bitmap = new MutableRoaringBitmap();

    public WrappedRoaringBitmap() {
        this(false);
    }

    public WrappedRoaringBitmap(boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization;
    }

    ImmutableBitmap toImmutableBitmap() {
        MutableRoaringBitmap mrb = this.bitmap.clone();
        if (this.compressRunOnSerialization) {
            mrb.runOptimize();
        }
        return new WrappedImmutableRoaringBitmap(mrb);
    }

    @Override
    public byte[] toBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.compressRunOnSerialization) {
                this.bitmap.runOptimize();
            }
            this.bitmap.serialize(new DataOutputStream(out));
            return out.toByteArray();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)mutableBitmap;
        MutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        this.bitmap.or(unwrappedOtherBitmap);
    }

    @Override
    public int getSizeInBytes() {
        if (this.compressRunOnSerialization) {
            this.bitmap.runOptimize();
        }
        return this.bitmap.serializedSizeInBytes();
    }

    @Override
    public void add(int entry) {
        this.bitmap.add(entry);
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    public void serialize(ByteBuffer buffer) {
        if (this.compressRunOnSerialization) {
            this.bitmap.runOptimize();
        }
        try {
            this.bitmap.serialize(new DataOutputStream(new OutputStream(){
                ByteBuffer mBB;

                OutputStream init(ByteBuffer mbb) {
                    this.mBB = mbb;
                    return this;
                }

                @Override
                public void close() {
                }

                @Override
                public void flush() {
                }

                @Override
                public void write(int b) {
                    this.mBB.put((byte)b);
                }

                @Override
                public void write(byte[] b) {
                    this.mBB.put(b);
                }

                @Override
                public void write(byte[] b, int off, int l) {
                    this.mBB.put(b, off, l);
                }
            }.init(buffer)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public void remove(int entry) {
        this.bitmap.remove(entry);
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.getIntIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)otherBitmap;
        MutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap(MutableRoaringBitmap.and(this.bitmap, unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }
}

