/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathParser;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;

public class JSONParseSpec
extends ParseSpec {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JSONPathSpec flattenSpec;
    private final Map<String, Boolean> featureSpec;

    @JsonCreator
    public JSONParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="flattenSpec") JSONPathSpec flattenSpec, @JsonProperty(value="featureSpec") Map<String, Boolean> featureSpec) {
        super(timestampSpec, dimensionsSpec);
        this.flattenSpec = flattenSpec != null ? flattenSpec : JSONPathSpec.DEFAULT;
        this.featureSpec = featureSpec == null ? new HashMap() : featureSpec;
        for (Map.Entry<String, Boolean> entry : this.featureSpec.entrySet()) {
            JsonParser.Feature feature = JsonParser.Feature.valueOf(entry.getKey());
            this.objectMapper.configure(feature, (boolean)entry.getValue());
        }
    }

    @Deprecated
    public JSONParseSpec(TimestampSpec ts, DimensionsSpec dims) {
        this(ts, dims, null, null);
    }

    @Override
    public void verify(List<String> usedCols) {
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new JSONPathParser(this.flattenSpec, this.objectMapper);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new JSONParseSpec(spec, this.getDimensionsSpec(), this.getFlattenSpec(), this.getFeatureSpec());
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new JSONParseSpec(this.getTimestampSpec(), spec, this.getFlattenSpec(), this.getFeatureSpec());
    }

    @JsonProperty
    public JSONPathSpec getFlattenSpec() {
        return this.flattenSpec;
    }

    @JsonProperty
    public Map<String, Boolean> getFeatureSpec() {
        return this.featureSpec;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSONParseSpec that = (JSONParseSpec)o;
        return Objects.equals(this.flattenSpec, that.flattenSpec) && Objects.equals(this.featureSpec, that.featureSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.flattenSpec, this.featureSpec);
    }

    public String toString() {
        return "JSONParseSpec{timestampSpec=" + this.getTimestampSpec() + ", dimensionsSpec=" + this.getDimensionsSpec() + ", flattenSpec=" + this.flattenSpec + ", featureSpec=" + this.featureSpec + '}';
    }
}

