/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.discovery;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.concurrent.LifecycleLock;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.io.druid.java.util.common.IOE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.RE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.FullResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.hive.druid.io.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelException;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DruidLeaderClient {
    private final Logger log = new Logger(DruidLeaderClient.class);
    private static final int MAX_RETRIES = 5;
    private final HttpClient httpClient;
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private final String nodeTypeToWatch;
    private final String leaderRequestPath;
    private final ServerDiscoverySelector serverDiscoverySelector;
    private LifecycleLock lifecycleLock = new LifecycleLock();
    private DruidNodeDiscovery druidNodeDiscovery;
    private AtomicReference<String> currentKnownLeader = new AtomicReference();

    public DruidLeaderClient(HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, String nodeTypeToWatch, String leaderRequestPath, ServerDiscoverySelector serverDiscoverySelector) {
        this.httpClient = httpClient;
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.nodeTypeToWatch = nodeTypeToWatch;
        this.leaderRequestPath = leaderRequestPath;
        this.serverDiscoverySelector = serverDiscoverySelector;
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.druidNodeDiscovery = this.druidNodeDiscoveryProvider.getForNodeType(this.nodeTypeToWatch);
            this.lifecycleLock.started();
            this.log.info("Started.", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        this.log.info("Stopped.", new Object[0]);
    }

    public Request makeRequest(HttpMethod httpMethod, String urlPath) throws IOException {
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return new Request(httpMethod, new URL(StringUtils.format("%s%s", this.getCurrentKnownLeader(true), urlPath)));
    }

    public FullResponseHolder go(Request request) throws IOException, InterruptedException {
        return this.go(request, new FullResponseHandler(Charsets.UTF_8));
    }

    public FullResponseHolder go(Request request, HttpResponseHandler<FullResponseHolder, FullResponseHolder> responseHandler) throws IOException, InterruptedException {
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        for (int counter = 0; counter < 5; ++counter) {
            FullResponseHolder fullResponseHolder;
            try {
                try {
                    fullResponseHolder = (FullResponseHolder)this.httpClient.go(request, responseHandler).get();
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfInstanceOf(e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf(e.getCause(), ChannelException.class);
                    throw new RE(e, "HTTP request to[%s] failed", request.getUrl());
                }
            }
            catch (IOException | ChannelException ex) {
                this.log.info("Request[%s] failed with msg [%s].", request.getUrl(), ex.getMessage());
                this.log.debug(ex, "Request[%s] failed.", request.getUrl());
                try {
                    if (request.getUrl().getQuery() == null) {
                        request = this.withUrl(request, new URL(StringUtils.format("%s%s", this.getCurrentKnownLeader(false), request.getUrl().getPath())));
                        continue;
                    }
                    request = this.withUrl(request, new URL(StringUtils.format("%s%s?%s", this.getCurrentKnownLeader(false), request.getUrl().getPath(), request.getUrl().getQuery())));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ISE(e, "failed to build url with path[%] and query string [%s].", request.getUrl().getPath(), request.getUrl().getQuery());
                }
            }
            if (HttpResponseStatus.TEMPORARY_REDIRECT.equals(fullResponseHolder.getResponse().getStatus())) {
                URL redirectUrl;
                String redirectUrlStr = fullResponseHolder.getResponse().headers().get("Location");
                if (redirectUrlStr == null) {
                    throw new IOE("No redirect location is found in response from url[%s].", request.getUrl());
                }
                this.log.info("Request[%s] received redirect response to location [%s].", request.getUrl(), redirectUrlStr);
                try {
                    redirectUrl = new URL(redirectUrlStr);
                }
                catch (MalformedURLException ex) {
                    throw new IOE(ex, "Malformed redirect location is found in response from url[%s], new location[%s].", request.getUrl(), redirectUrlStr);
                }
                this.currentKnownLeader.set(StringUtils.format("%s://%s:%s", redirectUrl.getProtocol(), redirectUrl.getHost(), redirectUrl.getPort()));
                request = this.withUrl(request, redirectUrl);
                continue;
            }
            return fullResponseHolder;
        }
        throw new IOE("Retries exhausted, couldn't fulfill request to [%s].", request.getUrl());
    }

    public String findCurrentLeader() {
        FullResponseHolder responseHolder;
        Preconditions.checkState(this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        try {
            responseHolder = this.go(this.makeRequest(HttpMethod.GET, this.leaderRequestPath));
        }
        catch (Exception ex) {
            throw new ISE(ex, "Couldn't find leader.", new Object[0]);
        }
        if (responseHolder.getStatus().getCode() == 200) {
            String leaderUrl = responseHolder.getContent();
            try {
                URL validatedUrl = new URL(leaderUrl);
                this.currentKnownLeader.set(leaderUrl);
                return validatedUrl.toString();
            }
            catch (MalformedURLException ex) {
                this.log.error(ex, "Received malformed leader url[%s].", leaderUrl);
            }
        }
        throw new ISE("Couldn't find leader, failed response status is [%s] and content [%s].", responseHolder.getStatus().getCode(), responseHolder.getContent());
    }

    private String getCurrentKnownLeader(boolean cached) throws IOException {
        String leader = this.currentKnownLeader.accumulateAndGet(null, (current, given) -> current == null || !cached ? this.pickOneHost() : current);
        if (leader == null) {
            throw new IOE("No known server", new Object[0]);
        }
        return leader;
    }

    @Nullable
    private String pickOneHost() {
        Server server = this.serverDiscoverySelector.pick();
        if (server != null) {
            return StringUtils.format("%s://%s:%s", server.getScheme(), server.getAddress(), server.getPort());
        }
        Iterator<DiscoveryDruidNode> iter = this.druidNodeDiscovery.getAllNodes().iterator();
        if (iter.hasNext()) {
            DiscoveryDruidNode node = iter.next();
            return StringUtils.format("%s://%s", node.getDruidNode().getServiceScheme(), node.getDruidNode().getHostAndPortToUse());
        }
        return null;
    }

    private Request withUrl(Request old, URL url) {
        Request req = new Request(old.getMethod(), url);
        req.addHeaderValues(old.getHeaders());
        if (old.hasContent()) {
            req.setContent(old.getContent());
        }
        return req;
    }
}

