/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.io.druid.java.util.common.parsers.AbstractFlatTextFormatParser;

public class DelimitedParser
extends AbstractFlatTextFormatParser {
    private final String delimiter;
    private final Splitter splitter;

    public DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, boolean hasHeaderRow, int maxSkipHeaderRows) {
        super(listDelimiter, hasHeaderRow, maxSkipHeaderRows);
        this.delimiter = delimiter != null ? delimiter : AbstractFlatTextFormatParser.FlatTextFormat.DELIMITED.getDefaultDelimiter();
        Preconditions.checkState(!this.delimiter.equals(this.getListDelimiter()), "Cannot have same delimiter and list delimiter of [%s]", this.delimiter);
        this.splitter = Splitter.on(this.delimiter);
    }

    public DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, Iterable<String> fieldNames, boolean hasHeaderRow, int maxSkipHeaderRows) {
        this(delimiter, listDelimiter, hasHeaderRow, maxSkipHeaderRows);
        this.setFieldNames(fieldNames);
    }

    @VisibleForTesting
    DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, String header) {
        this(delimiter, listDelimiter, false, 0);
        this.setFieldNames(header);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    protected List<String> parseLine(String input) throws IOException {
        return this.splitter.splitToList(input);
    }
}

