/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ObjectFlattener;

public class ObjectFlatteners {
    private ObjectFlatteners() {
    }

    public static <T> ObjectFlattener<T> create(final JSONPathSpec flattenSpec, final FlattenerMaker<T> flattenerMaker) {
        final LinkedHashMap<String, Function<Object, Object>> extractors = new LinkedHashMap<String, Function<Object, Object>>();
        for (JSONPathFieldSpec fieldSpec : flattenSpec.getFields()) {
            Function<Object, Object> extractor;
            switch (fieldSpec.getType()) {
                case ROOT: {
                    extractor = obj -> flattenerMaker.getRootField(obj, fieldSpec.getExpr());
                    break;
                }
                case PATH: {
                    extractor = flattenerMaker.makeJsonPathExtractor(fieldSpec.getExpr());
                    break;
                }
                case JQ: {
                    extractor = flattenerMaker.makeJsonQueryExtractor(fieldSpec.getExpr());
                    break;
                }
                default: {
                    throw new UOE("Unsupported field type[%s]", new Object[]{fieldSpec.getType()});
                }
            }
            if (extractors.put(fieldSpec.getName(), extractor) == null) continue;
            throw new IAE("Cannot have duplicate field definition: %s", fieldSpec.getName());
        }
        return new ObjectFlattener<T>(){

            @Override
            public Map<String, Object> flatten(final T obj) {
                return new AbstractMap<String, Object>(){

                    @Override
                    public int size() {
                        return this.keySet().size();
                    }

                    @Override
                    public boolean isEmpty() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsKey(Object key) {
                        if (key == null) {
                            return false;
                        }
                        return this.keySet().contains(key.toString());
                    }

                    @Override
                    public boolean containsValue(Object value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Object get(Object key) {
                        String keyString = key.toString();
                        Function extractor = (Function)extractors.get(keyString);
                        if (extractor != null) {
                            return extractor.apply(obj);
                        }
                        return flattenerMaker.getRootField(obj, keyString);
                    }

                    @Override
                    public Object put(String key, Object value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Object remove(Object key) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void putAll(Map<? extends String, ?> m) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void clear() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Set<String> keySet() {
                        if (flattenSpec.isUseFieldDiscovery()) {
                            Iterable<String> rootFields = flattenerMaker.discoverRootFields(obj);
                            if (extractors.isEmpty() && rootFields instanceof Set) {
                                return (Set)rootFields;
                            }
                            LinkedHashSet<String> keys = new LinkedHashSet<String>(extractors.keySet());
                            Iterables.addAll(keys, rootFields);
                            return keys;
                        }
                        return extractors.keySet();
                    }

                    @Override
                    public Collection<Object> values() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Set<Map.Entry<String, Object>> entrySet() {
                        return this.keySet().stream().map(field -> new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return field;
                            }

                            @Override
                            public Object getValue() {
                                return this.get(field);
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        }).collect(Collectors.toSet());
                    }
                };
            }
        };
    }

    public static interface FlattenerMaker<T> {
        public Iterable<String> discoverRootFields(T var1);

        public Object getRootField(T var1, String var2);

        public Function<T, Object> makeJsonPathExtractor(String var1);

        public Function<T, Object> makeJsonQueryExtractor(String var1);
    }
}

